"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogViewReference = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _uuid = require("uuid");
var _use_lazy_ref = require("../../../../hooks/use_lazy_ref");
var _log_views = require("../../../../../common/log_views");
var _use_kibana = require("../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// import { useMemo } from 'react';

const useLogViewReference = ({
  id,
  extraFields = []
}) => {
  const {
    services: {
      logViews: {
        client
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    loading,
    value: defaultLogView
  } = (0, _useAsync.default)(() => client.getLogView(_log_views.DEFAULT_LOG_VIEW), []);
  const logViewReference = (0, _use_lazy_ref.useLazyRef)(() => {
    return !defaultLogView ? null : {
      type: 'log-view-inline',
      id,
      attributes: {
        name: 'Hosts Logs View',
        description: 'Default view for hosts logs tab',
        logIndices: defaultLogView.attributes.logIndices,
        logColumns: [{
          timestampColumn: {
            id: '5e7f964a-be8a-40d8-88d2-fbcfbdca0e2f'
          }
        }, ...extraFields.map(fieldName => ({
          fieldColumn: {
            id: (0, _uuid.v4)(),
            field: fieldName
          }
        })), {
          messageColumn: {
            id: 'b645d6da-824b-4723-9a2a-e8cece1645c0'
          }
        }]
      }
    };
  });
  return {
    logViewReference: logViewReference.current,
    loading
  };
};
exports.useLogViewReference = useLogViewReference;