"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMESTAMP_FIELD = exports.RECOVERED_ALERTS = exports.METRIC_CHART_MIN_HEIGHT = exports.LOCAL_STORAGE_PAGE_SIZE_KEY = exports.LOCAL_STORAGE_HOST_LIMIT_KEY = exports.KPI_CHART_MIN_HEIGHT = exports.HOST_METRICS_DOC_HREF = exports.HOST_LIMIT_OPTIONS = exports.DEFAULT_PAGE_SIZE = exports.DEFAULT_HOST_LIMIT = exports.DATA_VIEW_PREFIX = exports.ALL_ALERTS = exports.ALERT_STATUS_QUERY = exports.ALERT_STATUS_ALL = exports.ACTIVE_ALERTS = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_STATUS_ALL = 'all';
exports.ALERT_STATUS_ALL = ALERT_STATUS_ALL;
const TIMESTAMP_FIELD = '@timestamp';
exports.TIMESTAMP_FIELD = TIMESTAMP_FIELD;
const DATA_VIEW_PREFIX = 'infra_metrics';
exports.DATA_VIEW_PREFIX = DATA_VIEW_PREFIX;
const DEFAULT_HOST_LIMIT = 100;
exports.DEFAULT_HOST_LIMIT = DEFAULT_HOST_LIMIT;
const DEFAULT_PAGE_SIZE = 10;
exports.DEFAULT_PAGE_SIZE = DEFAULT_PAGE_SIZE;
const LOCAL_STORAGE_HOST_LIMIT_KEY = 'hostsView:hostLimitSelection';
exports.LOCAL_STORAGE_HOST_LIMIT_KEY = LOCAL_STORAGE_HOST_LIMIT_KEY;
const LOCAL_STORAGE_PAGE_SIZE_KEY = 'hostsView:pageSizeSelection';
exports.LOCAL_STORAGE_PAGE_SIZE_KEY = LOCAL_STORAGE_PAGE_SIZE_KEY;
const KPI_CHART_MIN_HEIGHT = 150;
exports.KPI_CHART_MIN_HEIGHT = KPI_CHART_MIN_HEIGHT;
const METRIC_CHART_MIN_HEIGHT = 300;
exports.METRIC_CHART_MIN_HEIGHT = METRIC_CHART_MIN_HEIGHT;
const ALL_ALERTS = {
  status: ALERT_STATUS_ALL,
  label: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.alertStatusFilter.showAll', {
    defaultMessage: 'Show all'
  })
};
exports.ALL_ALERTS = ALL_ALERTS;
const ACTIVE_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_ACTIVE,
  query: {
    term: {
      [_ruleDataUtils.ALERT_STATUS]: {
        value: _ruleDataUtils.ALERT_STATUS_ACTIVE
      }
    }
  },
  label: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.alertStatusFilter.active', {
    defaultMessage: 'Active'
  })
};
exports.ACTIVE_ALERTS = ACTIVE_ALERTS;
const RECOVERED_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_RECOVERED,
  query: {
    term: {
      [_ruleDataUtils.ALERT_STATUS]: {
        value: _ruleDataUtils.ALERT_STATUS_RECOVERED
      }
    }
  },
  label: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.alertStatusFilter.recovered', {
    defaultMessage: 'Recovered'
  })
};
exports.RECOVERED_ALERTS = RECOVERED_ALERTS;
const ALERT_STATUS_QUERY = {
  [ACTIVE_ALERTS.status]: ACTIVE_ALERTS.query,
  [RECOVERED_ALERTS.status]: RECOVERED_ALERTS.query
};
exports.ALERT_STATUS_QUERY = ALERT_STATUS_QUERY;
const HOST_LIMIT_OPTIONS = [10, 20, 50, 100, 500];
exports.HOST_LIMIT_OPTIONS = HOST_LIMIT_OPTIONS;
const HOST_METRICS_DOC_HREF = 'https://ela.st/docs-infra-host-metrics';
exports.HOST_METRICS_DOC_HREF = HOST_METRICS_DOC_HREF;