"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/controls-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _rxjs = require("rxjs");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_control_panels_url_state = require("../../hooks/use_control_panels_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ControlsContent = ({
  dataView,
  filters,
  query,
  timeRange,
  onFiltersChange
}) => {
  const [controlPanels, setControlPanels] = (0, _use_control_panels_url_state.useControlPanels)(dataView);
  const subscriptions = (0, _react.useRef)(new _rxjs.Subscription());
  const getInitialInput = (0, _react.useCallback)(async () => {
    var _dataView$id;
    const initialInput = {
      id: (_dataView$id = dataView === null || dataView === void 0 ? void 0 : dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : '',
      viewMode: _public2.ViewMode.VIEW,
      chainingSystem: 'HIERARCHICAL',
      controlStyle: 'oneLine',
      defaultControlWidth: 'small',
      panels: controlPanels,
      filters,
      query,
      timeRange
    };
    return {
      initialInput
    };
  }, [controlPanels, dataView === null || dataView === void 0 ? void 0 : dataView.id, filters, query, timeRange]);
  const loadCompleteHandler = (0, _react.useCallback)(controlGroup => {
    if (!controlGroup) return;
    subscriptions.current.add(controlGroup.onFiltersPublished$.subscribe(newFilters => {
      onFiltersChange(newFilters);
    }));
    subscriptions.current.add(controlGroup.getInput$().subscribe(({
      panels
    }) => setControlPanels(panels)));
  }, [onFiltersChange, setControlPanels]);
  (0, _react.useEffect)(() => {
    const currentSubscriptions = subscriptions.current;
    return () => {
      currentSubscriptions.unsubscribe();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(ControlGroupContainer, null, /*#__PURE__*/_react.default.createElement(_public.ControlGroupRenderer, {
    getCreationOptions: getInitialInput,
    ref: loadCompleteHandler,
    timeRange: timeRange,
    query: query,
    filters: filters
  }));
};
exports.ControlsContent = ControlsContent;
const ControlGroupContainer = _common.euiStyled.div`
  .controlGroup {
    min-height: ${props => props.theme.eui.euiSizeXXL}
  }
`;