"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KPIGrid = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tile = require("./tile");
var _use_host_count = require("../../hooks/use_host_count");
var _translations = require("../../translations");
var _hosts_tile = require("./hosts_tile");
var _host_metrics_docs_link = require("../metric_explanation/host_metrics_docs_link");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensStyle = {
  height: _constants.KPI_CHART_MIN_HEIGHT
};
const KPI_CHARTS = [{
  type: 'cpuUsage',
  trendLine: true,
  backgroundColor: '#F1D86F',
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.cpuUsage.title', {
    defaultMessage: 'CPU Usage'
  }),
  toolTip: _translations.TOOLTIP.cpuUsage
}, {
  type: 'normalizedLoad1m',
  trendLine: true,
  backgroundColor: '#79AAD9',
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.normalizedLoad1m.title', {
    defaultMessage: 'Normalized Load'
  }),
  toolTip: _translations.TOOLTIP.normalizedLoad1m
}, {
  type: 'memoryUsage',
  trendLine: true,
  backgroundColor: '#A987D1',
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.memoryUsage.title', {
    defaultMessage: 'Memory Usage'
  }),
  toolTip: _translations.TOOLTIP.memoryUsage
}, {
  type: 'diskSpaceUsage',
  trendLine: true,
  backgroundColor: '#F5A35C',
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.diskSpaceUsage.title', {
    defaultMessage: 'Disk Space Usage'
  }),
  toolTip: _translations.TOOLTIP.tx
}];
const KPIGrid = () => {
  return /*#__PURE__*/_react.default.createElement(_use_host_count.HostCountProvider, null, /*#__PURE__*/_react.default.createElement(_host_metrics_docs_link.HostMetricsDocsLink, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    style: {
      flexGrow: 0
    },
    "data-test-subj": "hostsViewKPIGrid"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hosts_tile.HostsTile, {
    style: lensStyle
  })), KPI_CHARTS.map(({
    ...chartProp
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: chartProp.type
  }, /*#__PURE__*/_react.default.createElement(_tile.Tile, (0, _extends2.default)({}, chartProp, {
    style: lensStyle
  }))))));
};
exports.KPIGrid = KPIGrid;