"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _use_intersection_once = require("../../../../../hooks/use_intersection_once");
var _chart_loader = require("./chart_loader");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LensWrapper = /*#__PURE__*/_react.default.memo(({
  attributes,
  dateRange,
  filters,
  id,
  query,
  extraActions,
  style,
  onBrushEnd,
  lastReloadRequestTime,
  loading = false,
  hasTitle = false
}) => {
  const intersectionRef = (0, _react.useRef)(null);
  const [loadedOnce, setLoadedOnce] = (0, _react.useState)(false);
  const [state, setState] = (0, _react.useState)({
    attributes,
    lastReloadRequestTime,
    query,
    filters,
    dateRange
  });
  const {
    services: {
      lens
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    intersectedOnce,
    intersection
  } = (0, _use_intersection_once.useIntersectedOnce)(intersectionRef, {
    threshold: 1
  });
  const EmbeddableComponent = lens.EmbeddableComponent;
  (0, _react.useEffect)(() => {
    var _intersection$interse;
    if (((_intersection$interse = intersection === null || intersection === void 0 ? void 0 : intersection.intersectionRatio) !== null && _intersection$interse !== void 0 ? _intersection$interse : 0) === 1) {
      setState({
        attributes,
        lastReloadRequestTime,
        query,
        filters,
        dateRange
      });
    }
  }, [attributes, dateRange, filters, intersection === null || intersection === void 0 ? void 0 : intersection.intersectionRatio, lastReloadRequestTime, query]);
  const isReady = state.attributes && intersectedOnce;
  const onLoad = (0, _react.useCallback)(() => {
    if (!loadedOnce) {
      setLoadedOnce(true);
    }
  }, [loadedOnce]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: intersectionRef
  }, /*#__PURE__*/_react.default.createElement(_chart_loader.ChartLoader, {
    loading: loading || !isReady,
    loadedOnce: loadedOnce,
    style: style,
    hasTitle: hasTitle
  }, state.attributes && /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: id,
    style: style,
    attributes: state.attributes,
    viewMode: _public.ViewMode.VIEW,
    timeRange: state.dateRange,
    query: state.query,
    filters: state.filters,
    extraActions: extraActions,
    lastReloadRequestTime: state.lastReloadRequestTime,
    executionContext: {
      type: 'infrastructure_observability_hosts_view',
      name: id
    },
    onBrushEnd: onBrushEnd,
    onLoad: onLoad
  })));
});
exports.LensWrapper = LensWrapper;