"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryAnomaliesResults = void 0;
var _react = require("react");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _use_tracked_promise = require("../../../utils/use_tracked_promise");
var _get_log_entry_anomalies = require("./service_calls/get_log_entry_anomalies");
var _get_log_entry_anomalies_datasets = require("./service_calls/get_log_entry_anomalies_datasets");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stateReducer = (state, action) => {
  const resetPagination = {
    page: 1,
    paginationCursor: undefined
  };
  switch (action.type) {
    case 'changePaginationOptions':
      return {
        ...state,
        ...resetPagination,
        ...action.payload
      };
    case 'changeSortOptions':
      return {
        ...state,
        ...resetPagination,
        ...action.payload
      };
    case 'changeHasNextPage':
      return {
        ...state,
        ...action.payload
      };
    case 'changeLastReceivedCursors':
      return {
        ...state,
        ...action.payload
      };
    case 'fetchNextPage':
      return state.lastReceivedCursors ? {
        ...state,
        page: state.page + 1,
        paginationCursor: {
          searchAfter: state.lastReceivedCursors.nextPageCursor
        }
      } : state;
    case 'fetchPreviousPage':
      return state.lastReceivedCursors ? {
        ...state,
        page: state.page - 1,
        paginationCursor: {
          searchBefore: state.lastReceivedCursors.previousPageCursor
        }
      } : state;
    case 'changeTimeRange':
      return {
        ...state,
        ...resetPagination,
        ...action.payload
      };
    case 'changeFilteredDatasets':
      return {
        ...state,
        ...resetPagination,
        ...action.payload
      };
    default:
      return state;
  }
};
const STATE_DEFAULTS = {
  // NOTE: This piece of state is purely for the client side, it could be extracted out of the hook.
  page: 1,
  // Cursor from the last request
  lastReceivedCursors: undefined,
  // Cursor to use for the next request. For the first request, and therefore not paging, this will be undefined.
  paginationCursor: undefined,
  hasNextPage: false
};
const useLogEntryAnomaliesResults = ({
  endTime,
  startTime,
  logViewReference,
  defaultSortOptions,
  defaultPaginationOptions,
  onGetLogEntryAnomaliesDatasetsError,
  filteredDatasets
}) => {
  const initStateReducer = stateDefaults => {
    return {
      ...stateDefaults,
      paginationOptions: defaultPaginationOptions,
      sortOptions: defaultSortOptions,
      filteredDatasets,
      timeRange: {
        start: startTime,
        end: endTime
      }
    };
  };
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [reducerState, dispatch] = (0, _react.useReducer)(stateReducer, STATE_DEFAULTS, initStateReducer);
  const [logEntryAnomalies, setLogEntryAnomalies] = (0, _react.useState)([]);
  const [getLogEntryAnomaliesRequest, getLogEntryAnomalies] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: async () => {
      const {
        timeRange: {
          start: queryStartTime,
          end: queryEndTime
        },
        sortOptions,
        paginationOptions,
        paginationCursor,
        filteredDatasets: queryFilteredDatasets
      } = reducerState;
      return await (0, _get_log_entry_anomalies.callGetLogEntryAnomaliesAPI)({
        logViewReference,
        startTime: queryStartTime,
        endTime: queryEndTime,
        sort: sortOptions,
        pagination: {
          ...paginationOptions,
          cursor: paginationCursor
        },
        datasets: queryFilteredDatasets
      }, services.http.fetch);
    },
    onResolve: ({
      data: {
        anomalies,
        paginationCursors: requestCursors,
        hasMoreEntries
      }
    }) => {
      const {
        paginationCursor
      } = reducerState;
      if (requestCursors) {
        dispatch({
          type: 'changeLastReceivedCursors',
          payload: {
            lastReceivedCursors: requestCursors
          }
        });
      }
      // Check if we have more "next" entries. "Page" covers the "previous" scenario,
      // since we need to know the page we're on anyway.
      if (!paginationCursor || paginationCursor && 'searchAfter' in paginationCursor) {
        dispatch({
          type: 'changeHasNextPage',
          payload: {
            hasNextPage: hasMoreEntries
          }
        });
      } else if (paginationCursor && 'searchBefore' in paginationCursor) {
        // We've requested a previous page, therefore there is a next page.
        dispatch({
          type: 'changeHasNextPage',
          payload: {
            hasNextPage: true
          }
        });
      }
      setLogEntryAnomalies(anomalies);
    }
  }, [logViewReference, dispatch, reducerState.timeRange, reducerState.sortOptions, reducerState.paginationOptions, reducerState.paginationCursor, reducerState.filteredDatasets]);
  const changeSortOptions = (0, _react.useCallback)(nextSortOptions => {
    dispatch({
      type: 'changeSortOptions',
      payload: {
        sortOptions: nextSortOptions
      }
    });
  }, [dispatch]);
  const changePaginationOptions = (0, _react.useCallback)(nextPaginationOptions => {
    dispatch({
      type: 'changePaginationOptions',
      payload: {
        paginationOptions: nextPaginationOptions
      }
    });
  }, [dispatch]);

  // Time range has changed
  (0, _react.useEffect)(() => {
    dispatch({
      type: 'changeTimeRange',
      payload: {
        timeRange: {
          start: startTime,
          end: endTime
        }
      }
    });
  }, [startTime, endTime]);

  // Selected datasets have changed
  (0, _react.useEffect)(() => {
    dispatch({
      type: 'changeFilteredDatasets',
      payload: {
        filteredDatasets
      }
    });
  }, [filteredDatasets]);
  (0, _react.useEffect)(() => {
    getLogEntryAnomalies();
  }, [getLogEntryAnomalies]);
  const handleFetchNextPage = (0, _react.useCallback)(() => {
    if (reducerState.lastReceivedCursors) {
      dispatch({
        type: 'fetchNextPage'
      });
    }
  }, [dispatch, reducerState]);
  const handleFetchPreviousPage = (0, _react.useCallback)(() => {
    if (reducerState.lastReceivedCursors) {
      dispatch({
        type: 'fetchPreviousPage'
      });
    }
  }, [dispatch, reducerState]);
  const isLoadingLogEntryAnomalies = (0, _react.useMemo)(() => getLogEntryAnomaliesRequest.state === 'pending', [getLogEntryAnomaliesRequest.state]);
  const hasFailedLoadingLogEntryAnomalies = (0, _react.useMemo)(() => getLogEntryAnomaliesRequest.state === 'rejected', [getLogEntryAnomaliesRequest.state]);

  // Anomalies datasets
  const [logEntryAnomaliesDatasets, setLogEntryAnomaliesDatasets] = (0, _react.useState)([]);
  const [getLogEntryAnomaliesDatasetsRequest, getLogEntryAnomaliesDatasets] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: async () => {
      return await (0, _get_log_entry_anomalies_datasets.callGetLogEntryAnomaliesDatasetsAPI)({
        logViewReference,
        startTime,
        endTime
      }, services.http.fetch);
    },
    onResolve: ({
      data: {
        datasets
      }
    }) => {
      setLogEntryAnomaliesDatasets(datasets);
    },
    onReject: error => {
      if (error instanceof Error && !(error instanceof _use_tracked_promise.CanceledPromiseError) && onGetLogEntryAnomaliesDatasetsError) {
        onGetLogEntryAnomaliesDatasetsError(error);
      }
    }
  }, [endTime, logViewReference, startTime]);
  const isLoadingDatasets = (0, _react.useMemo)(() => getLogEntryAnomaliesDatasetsRequest.state === 'pending', [getLogEntryAnomaliesDatasetsRequest.state]);
  const hasFailedLoadingDatasets = (0, _react.useMemo)(() => getLogEntryAnomaliesDatasetsRequest.state === 'rejected', [getLogEntryAnomaliesDatasetsRequest.state]);
  (0, _useMount.default)(() => {
    getLogEntryAnomaliesDatasets();
  });
  return {
    logEntryAnomalies,
    getLogEntryAnomalies,
    isLoadingLogEntryAnomalies,
    isLoadingDatasets,
    hasFailedLoadingDatasets,
    datasets: logEntryAnomaliesDatasets,
    hasFailedLoadingLogEntryAnomalies,
    changeSortOptions,
    sortOptions: reducerState.sortOptions,
    changePaginationOptions,
    paginationOptions: reducerState.paginationOptions,
    fetchPreviousPage: reducerState.page > 1 ? handleFetchPreviousPage : undefined,
    fetchNextPage: reducerState.hasNextPage ? handleFetchNextPage : undefined,
    page: reducerState.page
  };
};
exports.useLogEntryAnomaliesResults = useLogEntryAnomaliesResults;