"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callGetLogEntryAnomaliesAPI = void 0;
var _http_api = require("../../../../../common/http_api");
var _runtime_types = require("../../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callGetLogEntryAnomaliesAPI = async (requestArgs, fetch) => {
  const {
    logViewReference,
    startTime,
    endTime,
    sort,
    pagination,
    datasets
  } = requestArgs;
  const response = await fetch(_http_api.LOG_ANALYSIS_GET_LOG_ENTRY_ANOMALIES_PATH, {
    method: 'POST',
    body: JSON.stringify(_http_api.getLogEntryAnomaliesRequestPayloadRT.encode({
      data: {
        logView: logViewReference,
        timeRange: {
          startTime,
          endTime
        },
        sort,
        pagination,
        datasets
      }
    })),
    version: '1'
  });
  return (0, _runtime_types.decodeOrThrow)(_http_api.getLogEntryAnomaliesSuccessReponsePayloadRT)(response);
};
exports.callGetLogEntryAnomaliesAPI = callGetLogEntryAnomaliesAPI;