"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryCountSparkline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _single_metric_comparison = require("./single_metric_comparison");
var _single_metric_sparkline = require("./single_metric_sparkline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryCountSparkline = ({
  currentCount,
  histograms,
  timeRange
}) => {
  const metric = (0, _react.useMemo)(() => {
    var _histograms$find$buck, _histograms$find, _histograms$find$buck2;
    return (_histograms$find$buck = (_histograms$find = histograms.find(histogram => histogram.histogramId === 'history')) === null || _histograms$find === void 0 ? void 0 : (_histograms$find$buck2 = _histograms$find.buckets) === null || _histograms$find$buck2 === void 0 ? void 0 : _histograms$find$buck2.map(({
      startTime: timestamp,
      logEntryCount: value
    }) => ({
      timestamp,
      value
    }))) !== null && _histograms$find$buck !== void 0 ? _histograms$find$buck : [];
  }, [histograms]);
  const referenceCount = (0, _react.useMemo)(() => {
    var _histograms$find$buck3, _histograms$find2, _histograms$find2$buc, _histograms$find2$buc2;
    return (_histograms$find$buck3 = (_histograms$find2 = histograms.find(histogram => histogram.histogramId === 'reference')) === null || _histograms$find2 === void 0 ? void 0 : (_histograms$find2$buc = _histograms$find2.buckets) === null || _histograms$find2$buc === void 0 ? void 0 : (_histograms$find2$buc2 = _histograms$find2$buc[0]) === null || _histograms$find2$buc2 === void 0 ? void 0 : _histograms$find2$buc2.logEntryCount) !== null && _histograms$find$buck3 !== void 0 ? _histograms$find$buck3 : 0;
  }, [histograms]);
  const overallTimeRange = (0, _react.useMemo)(() => ({
    endTime: timeRange.endTime,
    startTime: timeRange.startTime - (timeRange.endTime - timeRange.startTime)
  }), [timeRange.endTime, timeRange.startTime]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_single_metric_sparkline.SingleMetricSparkline, {
    metric: metric,
    timeRange: overallTimeRange
  }), /*#__PURE__*/_react.default.createElement(_single_metric_comparison.SingleMetricComparison, {
    previousValue: referenceCount,
    currentValue: currentCount
  }));
};
exports.LogEntryCountSparkline = LogEntryCountSparkline;