"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNodeDetailUrl = exports.RedirectToNodeDetail = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_metrics_time = require("../metrics/metric_detail/hooks/use_metrics_time");
var _query_params = require("./query_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RedirectToNodeDetail = ({
  match: {
    params: {
      nodeId,
      nodeType
    }
  },
  location
}) => {
  const searchString = (0, _use_metrics_time.replaceMetricTimeInQueryString)((0, _query_params.getFromFromLocation)(location), (0, _query_params.getToFromLocation)(location))('');
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `/detail/${nodeType}/${nodeId}?${searchString}`
  });
};
exports.RedirectToNodeDetail = RedirectToNodeDetail;
const getNodeDetailUrl = ({
  nodeType,
  nodeId,
  to,
  from
}) => {
  return {
    app: 'metrics',
    pathname: `link-to/${nodeType}-detail/${nodeId}`,
    search: to && from ? {
      to: `${to}`,
      from: `${from}`
    } : undefined
  };
};
exports.getNodeDetailUrl = getNodeDetailUrl;