"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToInventory = void 0;
var _react = _interopRequireDefault(require("react"));
var _queryString = require("query-string");
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// FIXME what would be the right way to build this query string?
const QUERY_STRING_TEMPLATE = "?waffleFilter=(expression:'',kind:kuery)&waffleTime=(currentTime:{timestamp},isAutoReloading:!f)&waffleOptions=(accountId:'',autoBounds:!t,boundsOverride:(max:1,min:0),customMetrics:!({customMetric}),customOptions:!(),groupBy:!(),legend:(palette:cool,reverseColors:!f,steps:10),metric:{metric},nodeType:{nodeType},region:'',sort:(by:name,direction:desc),timelineOpen:!f,view:map)";
const RedirectToInventory = ({
  location
}) => {
  const parsedQueryString = parseQueryString(location.search);
  const inventoryQueryString = QUERY_STRING_TEMPLATE.replace(/{(\w+)}/g, (_, key) => parsedQueryString[key] || '');
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: '/inventory' + inventoryQueryString
  });
};
exports.RedirectToInventory = RedirectToInventory;
function parseQueryString(search) {
  if (search.length === 0) {
    return {};
  }
  const obj = (0, _queryString.parse)(search.substring(1));

  // Force all values into string. If they are empty don't create the keys
  for (const key in obj) {
    if (Object.hasOwnProperty.call(obj, key)) {
      if (!obj[key]) {
        delete obj[key];
      }
      if (Array.isArray(obj.key)) {
        obj[key] = obj[key][0];
      }
    }
  }
  return obj;
}