"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToHostDetailViaIP = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _use_metrics_time = require("../metrics/metric_detail/hooks/use_metrics_time");
var _use_host_ip_to_name = require("./use_host_ip_to_name");
var _query_params = require("./query_params");
var _loading_page = require("../../components/loading_page");
var _error = require("../error");
var _metrics_source = require("../../containers/metrics_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RedirectToHostDetailViaIP = ({
  match: {
    params: {
      hostIp
    }
  },
  location
}) => {
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const {
    error,
    name
  } = (0, _use_host_ip_to_name.useHostIpToName)(hostIp, source && source.configuration && source.configuration.metricAlias || null);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_error.Error, {
      message: _i18n.i18n.translate('xpack.infra.linkTo.hostWithIp.error', {
        defaultMessage: 'Host not found with IP address "{hostIp}".',
        values: {
          hostIp
        }
      })
    });
  }
  const searchString = (0, _use_metrics_time.replaceMetricTimeInQueryString)((0, _query_params.getFromFromLocation)(location), (0, _query_params.getToFromLocation)(location))('');
  if (name) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: `/detail/host/${name}?${searchString}`
    });
  }
  return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPage, {
    message: _i18n.i18n.translate('xpack.infra.linkTo.hostWithIp.loading', {
      defaultMessage: 'Loading host with IP address "{hostIp}".',
      values: {
        hostIp
      }
    })
  });
};
exports.RedirectToHostDetailViaIP = RedirectToHostDetailViaIP;