"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateTimeInTimeFilterService = exports.updateTimeContextFromUrl = exports.updateTimeContextFromTimeRangeUpdate = exports.updateTimeContextFromTimeFilterService = exports.updateTimeContextFromRefreshIntervalUpdate = exports.subscribeToTimeFilterServiceChanges = exports.initializeFromTimeFilterService = void 0;
var _rxjs = require("rxjs");
var _xstate = require("xstate");
var _datemath = require("../../../utils/datemath");
var _defaults = require("./defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeFromTimeFilterService = ({
  timeFilterService
}) => (_context, _event) => send => {
  const timeRange = timeFilterService.getTime();
  const refreshInterval = timeFilterService.getRefreshInterval();
  send({
    type: 'INITIALIZED_FROM_TIME_FILTER_SERVICE',
    timeRange,
    refreshInterval
  });
};
exports.initializeFromTimeFilterService = initializeFromTimeFilterService;
const updateTimeInTimeFilterService = ({
  timeFilterService
}) => (context, event) => {
  if ('timeRange' in context) {
    timeFilterService.setTime(context.timeRange);
  }
  if ('refreshInterval' in context) {
    timeFilterService.setRefreshInterval(context.refreshInterval);
  }
};
exports.updateTimeInTimeFilterService = updateTimeInTimeFilterService;
const subscribeToTimeFilterServiceChanges = ({
  timeFilterService
}) => context => (0, _rxjs.merge)(timeFilterService.getTimeUpdate$(), timeFilterService.getRefreshIntervalUpdate$()).pipe((0, _rxjs.map)(() => getTimefilterState(timeFilterService)), (0, _rxjs.map)(timeState => {
  return {
    type: 'TIME_FROM_TIME_FILTER_SERVICE_CHANGED',
    ...timeState
  };
}));
exports.subscribeToTimeFilterServiceChanges = subscribeToTimeFilterServiceChanges;
const getTimefilterState = timeFilterService => ({
  timeRange: timeFilterService.getTime(),
  refreshInterval: timeFilterService.getRefreshInterval()
});
const updateTimeContextFromTimeFilterService = _xstate.actions.assign((context, event) => {
  if (event.type === 'TIME_FROM_TIME_FILTER_SERVICE_CHANGED' || event.type === 'INITIALIZED_FROM_TIME_FILTER_SERVICE') {
    return {
      ...getTimeFromEvent(context, event),
      refreshInterval: event.type === 'TIME_FROM_TIME_FILTER_SERVICE_CHANGED' ? event.refreshInterval : {
        ...context.refreshInterval,
        pause: event.refreshInterval.pause
      }
    };
  } else {
    return {};
  }
});
exports.updateTimeContextFromTimeFilterService = updateTimeContextFromTimeFilterService;
const updateTimeContextFromUrl = _xstate.actions.assign((context, event) => {
  if (event.type === 'INITIALIZED_FROM_URL') {
    return {
      ...('timeRange' in event && event.timeRange ? {
        ...getTimeFromEvent(context, event)
      } : {}),
      ...('refreshInterval' in event && event.refreshInterval ? {
        refreshInterval: event.refreshInterval
      } : {})
    };
  } else {
    return {};
  }
});
exports.updateTimeContextFromUrl = updateTimeContextFromUrl;
const updateTimeContextFromTimeRangeUpdate = _xstate.actions.assign((context, event) => {
  if ('timeRange' in event && event.type === 'UPDATE_TIME_RANGE') {
    return getTimeFromEvent(context, event);
  } else {
    return {};
  }
});
exports.updateTimeContextFromTimeRangeUpdate = updateTimeContextFromTimeRangeUpdate;
const updateTimeContextFromRefreshIntervalUpdate = _xstate.actions.assign((context, event) => {
  if ('refreshInterval' in event && 'refreshInterval' in context && event.type === 'UPDATE_REFRESH_INTERVAL') {
    var _event$refreshInterva, _event$refreshInterva2, _datemathToEpochMilli, _datemathToEpochMilli2;
    const pause = (_event$refreshInterva = event.refreshInterval.pause) !== null && _event$refreshInterva !== void 0 ? _event$refreshInterva : context.refreshInterval.pause;
    const value = (_event$refreshInterva2 = event.refreshInterval.value) !== null && _event$refreshInterva2 !== void 0 ? _event$refreshInterva2 : context.refreshInterval.value;
    const nowTimestamp = Date.now();
    const draftContext = {
      refreshInterval: {
        pause,
        value
      },
      ...(!pause ? {
        timeRange: {
          ..._defaults.DEFAULT_REFRESH_TIME_RANGE,
          lastChangedCompletely: nowTimestamp
        }
      } : {}),
      ...(!pause ? {
        timestamps: {
          startTimestamp: (_datemathToEpochMilli = (0, _datemath.datemathToEpochMillis)(_defaults.DEFAULT_REFRESH_TIME_RANGE.from, 'down')) !== null && _datemathToEpochMilli !== void 0 ? _datemathToEpochMilli : 0,
          endTimestamp: (_datemathToEpochMilli2 = (0, _datemath.datemathToEpochMillis)(_defaults.DEFAULT_REFRESH_TIME_RANGE.to, 'up')) !== null && _datemathToEpochMilli2 !== void 0 ? _datemathToEpochMilli2 : 0,
          lastChangedTimestamp: nowTimestamp
        }
      } : {})
    };
    return draftContext;
  } else {
    return {};
  }
});
exports.updateTimeContextFromRefreshIntervalUpdate = updateTimeContextFromRefreshIntervalUpdate;
const getTimeFromEvent = (context, event) => {
  var _event$timeRange$from, _event$timeRange, _event$timeRange$to, _event$timeRange2, _event$timeRange3, _event$timeRange4, _event$timeRange5, _event$timeRange6;
  if (!('timeRange' in event) || !('timeRange' in context) || !('timestamps' in context)) {
    throw new Error('Missing keys to get time from event');
  }
  const nowTimestamp = Date.now();
  const from = (_event$timeRange$from = (_event$timeRange = event.timeRange) === null || _event$timeRange === void 0 ? void 0 : _event$timeRange.from) !== null && _event$timeRange$from !== void 0 ? _event$timeRange$from : context.timeRange.from;
  const to = (_event$timeRange$to = (_event$timeRange2 = event.timeRange) === null || _event$timeRange2 === void 0 ? void 0 : _event$timeRange2.to) !== null && _event$timeRange$to !== void 0 ? _event$timeRange$to : context.timeRange.to;
  const fromTimestamp = (_event$timeRange3 = event.timeRange) !== null && _event$timeRange3 !== void 0 && _event$timeRange3.from ? (0, _datemath.datemathToEpochMillis)(from, 'down') : context.timestamps.startTimestamp;
  const toTimestamp = (_event$timeRange4 = event.timeRange) !== null && _event$timeRange4 !== void 0 && _event$timeRange4.to ? (0, _datemath.datemathToEpochMillis)(to, 'up') : context.timestamps.endTimestamp;
  return {
    timeRange: {
      from,
      to,
      lastChangedCompletely: (_event$timeRange5 = event.timeRange) !== null && _event$timeRange5 !== void 0 && _event$timeRange5.from && (_event$timeRange6 = event.timeRange) !== null && _event$timeRange6 !== void 0 && _event$timeRange6.to ? nowTimestamp : context.timeRange.lastChangedCompletely
    },
    timestamps: {
      startTimestamp: fromTimestamp !== null && fromTimestamp !== void 0 ? fromTimestamp : 0,
      endTimestamp: toTimestamp !== null && toTimestamp !== void 0 ? toTimestamp : 0,
      lastChangedTimestamp: nowTimestamp
    }
  };
};