"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithLogTextviewUrlState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _url_state = require("../../utils/url_state");
var _log_view_configuration = require("./log_view_configuration");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WithLogTextviewUrlState = () => {
  const {
    textScale,
    textWrap,
    setTextScale,
    setTextWrap
  } = (0, _log_view_configuration.useLogViewConfigurationContext)();
  const urlState = (0, _react.useMemo)(() => ({
    textScale,
    wrap: textWrap
  }), [textScale, textWrap]);
  return /*#__PURE__*/_react.default.createElement(_url_state.UrlStateContainer, {
    urlState: urlState,
    urlStateKey: "logTextview",
    mapToUrlState: mapToUrlState,
    onChange: newUrlState => {
      if (newUrlState && newUrlState.textScale) {
        setTextScale(newUrlState.textScale);
      }
      if (newUrlState && typeof newUrlState.wrap !== 'undefined') {
        setTextWrap(newUrlState.wrap);
      }
    },
    onInitialize: newUrlState => {
      if (newUrlState && newUrlState.textScale) {
        setTextScale(newUrlState.textScale);
      }
      if (newUrlState && typeof newUrlState.wrap !== 'undefined') {
        setTextWrap(newUrlState.wrap);
      }
    }
  });
};
exports.WithLogTextviewUrlState = WithLogTextviewUrlState;
const mapToUrlState = value => value ? {
  textScale: mapToTextScaleUrlState(value.textScale),
  wrap: mapToWrapUrlState(value.wrap)
} : undefined;
const mapToTextScaleUrlState = value => _log_view_configuration.availableTextScales.includes(value) ? value : undefined;
const mapToWrapUrlState = value => typeof value === 'boolean' ? value : undefined;