"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryMessageColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _log_entry = require("../../../utils/log_entry");
var _field_value = require("./field_value");
var _log_entry_column = require("./log_entry_column");
var _text_styles = require("./text_styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryMessageColumn = /*#__PURE__*/(0, _react.memo)(({
  columnValue,
  highlights,
  isActiveHighlight,
  wrapMode,
  render
}) => {
  const message = (0, _react.useMemo)(() => (0, _log_entry.isMessageColumn)(columnValue) ? formatMessageSegments(columnValue.message, highlights, isActiveHighlight) : null, [columnValue, highlights, isActiveHighlight]);
  const messageAsString = (0, _react.useMemo)(() => (0, _log_entry.isMessageColumn)(columnValue) ? renderMessageSegments(columnValue.message) : '', [columnValue]);
  return /*#__PURE__*/_react.default.createElement(MessageColumnContent, {
    wrapMode: wrapMode
  }, render ? render(messageAsString) : message);
});
exports.LogEntryMessageColumn = LogEntryMessageColumn;
const MessageColumnContent = (0, _common.euiStyled)(_log_entry_column.LogEntryColumnContent)`
  text-overflow: ellipsis;
  ${props => props.wrapMode === 'long' ? _text_styles.longWrappedContentStyle : props.wrapMode === 'pre-wrapped' ? _text_styles.preWrappedContentStyle : _text_styles.unwrappedContentStyle};
`;
const formatMessageSegments = (messageSegments, highlights, isActiveHighlight) => messageSegments.map((messageSegment, index) => {
  if ((0, _log_entry.isFieldSegment)(messageSegment)) {
    // we only support one highlight for now
    const [firstHighlight = []] = highlights.map(highlight => {
      if ((0, _log_entry.isHighlightMessageColumn)(highlight)) {
        const segment = highlight.message[index];
        if ((0, _log_entry.isHighlightFieldSegment)(segment)) {
          return segment.highlights;
        }
      }
      return [];
    });
    return /*#__PURE__*/_react.default.createElement(_field_value.FieldValue, {
      highlightTerms: firstHighlight,
      isActiveHighlight: isActiveHighlight,
      key: `MessageSegment-${index}`,
      value: messageSegment.value
    });
  } else if ((0, _log_entry.isConstantSegment)(messageSegment)) {
    return messageSegment.constant;
  }
  return 'failed to format message';
});
const renderMessageSegments = messageSegments => {
  return messageSegments.map(messageSegment => {
    if ((0, _log_entry.isConstantSegment)(messageSegment)) {
      return messageSegment.constant;
    }
    if ((0, _log_entry.isFieldSegment)(messageSegment)) {
      return messageSegment.value.toString();
    }
  }).join(' ');
};