"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.highlightFieldValue = exports.HighlightMarker = exports.ActiveHighlightMarker = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _styles = require("../../../utils/styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActiveHighlightMarker = _common.euiStyled.mark`
  color: ${props => (0, _styles.chooseLightOrDarkColor)(props.theme.eui.euiColorAccent, props.theme.eui.euiColorEmptyShade, props.theme.eui.euiColorDarkestShade)};
  background-color: ${props => props.theme.eui.euiColorAccent};
  outline: 1px solid ${props => props.theme.eui.euiColorAccent};
  };
`;
exports.ActiveHighlightMarker = ActiveHighlightMarker;
const HighlightMarker = _common.euiStyled.mark`
  color: ${props => (0, _styles.chooseLightOrDarkColor)((0, _styles.tintOrShade)(props.theme.eui.euiTextColor, props.theme.eui.euiColorAccent, 0.7, 0.5), props.theme.eui.euiColorEmptyShade, props.theme.eui.euiColorDarkestShade)};
  background-color: ${props => (0, _styles.tintOrShade)(props.theme.eui.euiTextColor, props.theme.eui.euiColorAccent, 0.7, 0.5)};
  outline: 1px solid ${props => (0, _styles.tintOrShade)(props.theme.eui.euiTextColor, props.theme.eui.euiColorAccent, 0.7, 0.5)};
  };
`;
exports.HighlightMarker = HighlightMarker;
const highlightFieldValue = (value, highlightTerms, HighlightComponent) => highlightTerms.reduce((fragments, highlightTerm, index) => {
  const lastFragment = fragments[fragments.length - 1];
  if (typeof lastFragment !== 'string') {
    return fragments;
  }
  const highlightTermPosition = lastFragment.indexOf(highlightTerm);
  if (highlightTermPosition > -1) {
    return [...fragments.slice(0, fragments.length - 1), lastFragment.slice(0, highlightTermPosition), /*#__PURE__*/_react.default.createElement(HighlightComponent, {
      key: `highlight-${highlightTerm}-${index}`
    }, highlightTerm), lastFragment.slice(highlightTermPosition + highlightTerm.length)];
  } else {
    return fragments;
  }
}, [value]);
exports.highlightFieldValue = highlightFieldValue;