"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogColumnHeadersWrapper = exports.LogColumnHeaders = exports.LogColumnHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _polished = require("polished");
var _common = require("@kbn/kibana-react-plugin/common");
var _log_entry_column = require("./log_entry_column");
var _vertical_scroll_panel = require("./vertical_scroll_panel");
var _log_position = require("../../../containers/logs/log_position");
var _datetime = require("../../../../common/formatters/datetime");
var _log_column_render_configuration = require("../../../utils/log_column_render_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogColumnHeaders = ({
  columnConfigurations,
  columnWidths
}) => {
  const {
    firstVisiblePosition
  } = (0, _log_position.useLogPositionStateContext)();
  return /*#__PURE__*/_react.default.createElement(LogColumnHeadersWrapper, null, columnConfigurations.map(columnConfiguration => {
    if ((0, _log_column_render_configuration.isTimestampColumnRenderConfiguration)(columnConfiguration)) {
      let columnHeader;
      if (columnConfiguration.timestampColumn.header === false) {
        columnHeader = null;
      } else if (typeof columnConfiguration.timestampColumn.header === 'string') {
        columnHeader = columnConfiguration.timestampColumn.header;
      } else {
        columnHeader = firstVisiblePosition ? (0, _datetime.localizedDate)(firstVisiblePosition.time) : _i18n.i18n.translate('xpack.infra.logs.stream.timestampColumnTitle', {
          defaultMessage: 'Timestamp'
        });
      }
      return /*#__PURE__*/_react.default.createElement(LogColumnHeader, {
        key: columnConfiguration.timestampColumn.id,
        columnWidth: columnWidths[columnConfiguration.timestampColumn.id],
        "data-test-subj": "logColumnHeader timestampLogColumnHeader"
      }, columnHeader);
    } else if ((0, _log_column_render_configuration.isMessageColumnRenderConfiguration)(columnConfiguration)) {
      let columnHeader;
      if (columnConfiguration.messageColumn.header === false) {
        columnHeader = null;
      } else if (typeof columnConfiguration.messageColumn.header === 'string') {
        columnHeader = columnConfiguration.messageColumn.header;
      } else {
        columnHeader = _i18n.i18n.translate('xpack.infra.logs.stream.messageColumnTitle', {
          defaultMessage: 'Message'
        });
      }
      return /*#__PURE__*/_react.default.createElement(LogColumnHeader, {
        columnWidth: columnWidths[columnConfiguration.messageColumn.id],
        "data-test-subj": "logColumnHeader messageLogColumnHeader",
        key: columnConfiguration.messageColumn.id
      }, columnHeader);
    } else if ((0, _log_column_render_configuration.isFieldColumnRenderConfiguration)(columnConfiguration)) {
      let columnHeader;
      if (columnConfiguration.fieldColumn.header === false) {
        columnHeader = null;
      } else if (typeof columnConfiguration.fieldColumn.header === 'string') {
        columnHeader = columnConfiguration.fieldColumn.header;
      } else {
        columnHeader = columnConfiguration.fieldColumn.field;
      }
      return /*#__PURE__*/_react.default.createElement(LogColumnHeader, {
        columnWidth: columnWidths[columnConfiguration.fieldColumn.id],
        "data-test-subj": "logColumnHeader fieldLogColumnHeader",
        key: columnConfiguration.fieldColumn.id
      }, columnHeader);
    }
  }));
};
exports.LogColumnHeaders = LogColumnHeaders;
const LogColumnHeader = ({
  children,
  columnWidth,
  'data-test-subj': dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(LogColumnHeaderWrapper, (0, _extends2.default)({
  "data-test-subj": dataTestSubj
}, columnWidth), /*#__PURE__*/_react.default.createElement(LogColumnHeaderContent, null, children));
exports.LogColumnHeader = LogColumnHeader;
const LogColumnHeadersWrapper = _common.euiStyled.div.attrs(props => {
  var _props$role;
  return {
    role: (_props$role = props.role) !== null && _props$role !== void 0 ? _props$role : 'row'
  };
})`
  align-items: stretch;
  display: flex;
  flex-direction: row;
  flex-wrap: nowrap;
  justify-content: flex-start;
  overflow: hidden;
  padding-right: ${_vertical_scroll_panel.ASSUMED_SCROLLBAR_WIDTH}px;
  border-bottom: ${props => props.theme.eui.euiBorderThin};
  box-shadow: 0 2px 2px -1px ${props => (0, _polished.transparentize)(0.3, props.theme.eui.euiColorLightShade)};
  position: relative;
  z-index: 1;
`;
exports.LogColumnHeadersWrapper = LogColumnHeadersWrapper;
const LogColumnHeaderWrapper = (0, _common.euiStyled)(_log_entry_column.LogEntryColumn).attrs(props => {
  var _props$role2;
  return {
    role: (_props$role2 = props.role) !== null && _props$role2 !== void 0 ? _props$role2 : 'columnheader'
  };
})`
  align-items: center;
  display: flex;
  flex-direction: row;
  height: 32px;
  overflow: hidden;
`;
const LogColumnHeaderContent = (0, _common.euiStyled)(_log_entry_column.LogEntryColumnContent)`
  color: ${props => props.theme.eui.euiTitleColor};
  font-size: ${props => props.theme.eui.euiFontSizeS};
  font-weight: ${props => props.theme.eui.euiFontWeightSemiBold};
  line-height: ${props => props.theme.eui.euiLineHeight};
  text-overflow: clip;
  white-space: pre;
`;