"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchMarkers = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _d3Scale = require("d3-scale");
var React = _interopRequireWildcard(require("react"));
var _search_marker = require("./search_marker");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchMarkers extends React.PureComponent {
  render() {
    const {
      buckets,
      start,
      end,
      width,
      height,
      jumpToTarget,
      className
    } = this.props;
    const classes = (0, _classnames.default)('minimapSearchMarkers', className);
    if (start >= end || height <= 0 || Object.keys(buckets).length <= 0) {
      return null;
    }
    const yScale = (0, _d3Scale.scaleTime)().domain([start, end]).range([0, height]);
    return /*#__PURE__*/React.createElement("g", {
      transform: `translate(${width / 2}, 0)`,
      className: classes
    }, buckets.map(bucket => {
      var _yScale, _yScale2;
      return /*#__PURE__*/React.createElement("g", {
        key: `${bucket.representativeKey.time}:${bucket.representativeKey.tiebreaker}`,
        transform: `translate(0, ${yScale(bucket.start)})`
      }, /*#__PURE__*/React.createElement(_search_marker.SearchMarker, {
        bucket: bucket,
        height: ((_yScale = yScale(bucket.end)) !== null && _yScale !== void 0 ? _yScale : 0) - ((_yScale2 = yScale(bucket.start)) !== null && _yScale2 !== void 0 ? _yScale2 : 0),
        width: width,
        jumpToTarget: jumpToTarget
      }));
    }));
  }
}
exports.SearchMarkers = SearchMarkers;