"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DensityChart = void 0;
var _d3Scale = require("d3-scale");
var _d3Shape = require("d3-shape");
var _lodash = require("lodash");
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DensityChart = ({
  buckets,
  start,
  end,
  width,
  height
}) => {
  var _xScale;
  if (start >= end || height <= 0 || width <= 0 || buckets.length <= 0) {
    return null;
  }
  const yScale = (0, _d3Scale.scaleTime)().domain([start, end]).range([0, height]);
  const xMax = (0, _lodash.max)(buckets.map(bucket => bucket.entriesCount)) || 0;
  const xScale = (0, _d3Scale.scaleLinear)().domain([0, xMax]).range([0, width]);
  const path = (0, _d3Shape.area)().x0((_xScale = xScale(0)) !== null && _xScale !== void 0 ? _xScale : 0).x1(bucket => {
    var _xScale2;
    return (_xScale2 = xScale(bucket.entriesCount)) !== null && _xScale2 !== void 0 ? _xScale2 : 0;
  }).y0(bucket => {
    var _yScale;
    return (_yScale = yScale(bucket.start)) !== null && _yScale !== void 0 ? _yScale : 0;
  }).y1(bucket => {
    var _yScale2;
    return (_yScale2 = yScale(bucket.end)) !== null && _yScale2 !== void 0 ? _yScale2 : 0;
  }).curve(_d3Shape.curveMonotoneY);
  const firstBucket = buckets[0];
  const lastBucket = buckets[buckets.length - 1];
  const pathBuckets = [
  // Make sure the graph starts at the count of the first point
  {
    start,
    end: start,
    entriesCount: firstBucket.entriesCount
  }, ...buckets,
  // Make sure the line ends at the height of the last point
  {
    start: lastBucket.end,
    end: lastBucket.end,
    entriesCount: lastBucket.entriesCount
  },
  // If the last point is not at the end of the minimap, make sure it doesn't extend indefinitely and goes to 0
  {
    start: end,
    end,
    entriesCount: 0
  }];
  const pathData = path(pathBuckets);
  return /*#__PURE__*/React.createElement("g", null, /*#__PURE__*/React.createElement(DensityChartPositiveBackground, {
    width: width,
    height: height
  }), /*#__PURE__*/React.createElement(PositiveAreaPath, {
    d: pathData || ''
  }));
};
exports.DensityChart = DensityChart;
const DensityChartPositiveBackground = _common.euiStyled.rect`
  fill: ${props => props.theme.darkMode ? props.theme.eui.euiColorLightShade : props.theme.eui.euiColorLightestShade};
`;
const PositiveAreaPath = _common.euiStyled.path`
  fill: ${props => props.theme.darkMode ? props.theme.eui.euiColorMediumShade : props.theme.eui.euiColorLightShade};
`;