"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryFlyout = exports.LogEntryFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _log_entry = require("../../../containers/logs/log_entry");
var _centered_flyout_body = require("../../centered_flyout_body");
var _data_search_error_callout = require("../../data_search_error_callout");
var _data_search_progress = require("../../data_search_progress");
var _log_entry_actions_menu = require("./log_entry_actions_menu");
var _log_entry_fields_table = require("./log_entry_fields_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntryFlyout = logViewReference => {
  const flyoutRef = (0, _react.useRef)();
  const {
    services: {
      http,
      data,
      uiSettings,
      application,
      observability
    },
    overlays: {
      openFlyout
    }
  } = (0, _public.useKibana)();
  const closeLogEntryFlyout = (0, _react.useCallback)(() => {
    var _flyoutRef$current;
    (_flyoutRef$current = flyoutRef.current) === null || _flyoutRef$current === void 0 ? void 0 : _flyoutRef$current.close();
  }, []);
  const openLogEntryFlyout = (0, _react.useCallback)(logEntryId => {
    const {
      Provider: KibanaReactContextProvider
    } = (0, _public.createKibanaReactContext)({
      http,
      data,
      uiSettings,
      application
    });
    flyoutRef.current = openFlyout( /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_public2.CoPilotContextProvider, {
      value: observability === null || observability === void 0 ? void 0 : observability.getCoPilotService()
    }, /*#__PURE__*/_react.default.createElement(LogEntryFlyout, {
      logEntryId: logEntryId,
      onCloseFlyout: closeLogEntryFlyout,
      logViewReference: logViewReference
    }))));
  }, [http, data, uiSettings, application, openFlyout, logViewReference, closeLogEntryFlyout, observability]);
  (0, _react.useEffect)(() => {
    return () => {
      closeLogEntryFlyout();
    };
  }, [closeLogEntryFlyout]);
  return {
    openLogEntryFlyout,
    closeLogEntryFlyout
  };
};
exports.useLogEntryFlyout = useLogEntryFlyout;
const LogEntryFlyout = ({
  logEntryId,
  onCloseFlyout,
  onSetFieldFilter,
  logViewReference
}) => {
  var _logEntryErrors$lengt;
  const {
    cancelRequest: cancelLogEntryRequest,
    errors: logEntryErrors,
    fetchLogEntry,
    isRequestRunning,
    loaded: logEntryRequestProgress,
    logEntry,
    total: logEntryRequestTotal
  } = (0, _log_entry.useLogEntry)({
    logViewReference,
    logEntryId
  });
  (0, _react.useEffect)(() => {
    if (logViewReference && logEntryId) {
      fetchLogEntry();
    }
  }, [fetchLogEntry, logViewReference, logEntryId]);
  const explainLogMessageParams = (0, _react.useMemo)(() => {
    return logEntry ? {
      logEntry: {
        fields: logEntry.fields
      }
    } : undefined;
  }, [logEntry]);
  const similarLogMessageParams = (0, _react.useMemo)(() => {
    return logEntry ? {
      logEntry: {
        fields: logEntry.fields
      }
    } : undefined;
  }, [logEntry]);
  const coPilotService = (0, _public2.useCoPilot)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCloseFlyout,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Details for log entry {logEntryId}",
    id: "xpack.infra.logFlyout.flyoutTitle",
    values: {
      logEntryId: logEntryId ? /*#__PURE__*/_react.default.createElement("code", null, logEntryId) : ''
    }
  }))), logEntry ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logFlyout.flyoutSubTitle",
    defaultMessage: "From index {indexName}",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement("code", null, logEntry.index)
    }
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      padding: 8
    },
    grow: false
  }, logEntry ? /*#__PURE__*/_react.default.createElement(_log_entry_actions_menu.LogEntryActionsMenu, {
    logEntry: logEntry
  }) : null))), isRequestRunning ? /*#__PURE__*/_react.default.createElement(_centered_flyout_body.CenteredEuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '75%'
    }
  }, /*#__PURE__*/_react.default.createElement(_data_search_progress.DataSearchProgress, {
    label: loadingProgressMessage,
    maxValue: logEntryRequestTotal,
    onCancel: cancelLogEntryRequest,
    value: logEntryRequestProgress
  }))) : logEntry ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: ((_logEntryErrors$lengt = logEntryErrors === null || logEntryErrors === void 0 ? void 0 : logEntryErrors.length) !== null && _logEntryErrors$lengt !== void 0 ? _logEntryErrors$lengt : 0) > 0 ? /*#__PURE__*/_react.default.createElement(_data_search_error_callout.DataSearchErrorCallout, {
      title: loadingErrorCalloutTitle,
      errors: logEntryErrors !== null && logEntryErrors !== void 0 ? logEntryErrors : [],
      onRetry: fetchLogEntry
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, coPilotService !== null && coPilotService !== void 0 && coPilotService.isEnabled() && explainLogMessageParams ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public2.CoPilotPrompt, {
    coPilot: coPilotService,
    title: explainLogMessageTitle,
    params: explainLogMessageParams,
    promptId: _common.CoPilotPromptId.LogsExplainMessage,
    feedbackEnabled: false
  })) : null, coPilotService !== null && coPilotService !== void 0 && coPilotService.isEnabled() && similarLogMessageParams ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public2.CoPilotPrompt, {
    coPilot: coPilotService,
    title: similarLogMessagesTitle,
    params: similarLogMessageParams,
    promptId: _common.CoPilotPromptId.LogsFindSimilar,
    feedbackEnabled: false
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_log_entry_fields_table.LogEntryFieldsTable, {
    logEntry: logEntry,
    onSetFieldFilter: onSetFieldFilter
  })))) : /*#__PURE__*/_react.default.createElement(_centered_flyout_body.CenteredEuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '75%'
    }
  }, /*#__PURE__*/_react.default.createElement(_data_search_error_callout.DataSearchErrorCallout, {
    title: loadingErrorCalloutTitle,
    errors: logEntryErrors !== null && logEntryErrors !== void 0 ? logEntryErrors : [],
    onRetry: fetchLogEntry
  }))));
};
exports.LogEntryFlyout = LogEntryFlyout;
const explainLogMessageTitle = _i18n.i18n.translate('xpack.infra.logFlyout.explainLogMessageTitle', {
  defaultMessage: "What's this message?"
});
const similarLogMessagesTitle = _i18n.i18n.translate('xpack.infra.logFlyout.similarLogMessagesTitle', {
  defaultMessage: 'How do I find similar log messages?'
});
const loadingProgressMessage = _i18n.i18n.translate('xpack.infra.logFlyout.loadingMessage', {
  defaultMessage: 'Searching log entry in shards'
});
const loadingErrorCalloutTitle = _i18n.i18n.translate('xpack.infra.logFlyout.loadingErrorCalloutTitle', {
  defaultMessage: 'Error while searching the log entry'
});