"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToUptime = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkToUptime = ({
  nodeType,
  nodeName,
  nodeIp
}) => {
  const {
    share
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "hostsView-flyout-uptime-link",
    size: "xs",
    iconSide: "left",
    iconType: "popout",
    flush: "both",
    onClick: () => share.url.locators.get(_public.uptimeOverviewLocatorID).navigate({
      [nodeType]: nodeName,
      ip: nodeIp
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.flyout.uptimeLinkLabel",
    defaultMessage: "Uptime"
  }));
};
exports.LinkToUptime = LinkToUptime;