"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToNodeDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _link_to = require("../../../pages/link_to");
var _inventory_models = require("../../../../common/inventory_models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkToNodeDetails = ({
  nodeId,
  nodeType,
  currentTime
}) => {
  const inventoryModel = (0, _inventory_models.findInventoryModel)(nodeType);
  const nodeDetailFrom = currentTime - inventoryModel.metrics.defaultTimeRangeInSeconds * 1000;
  const nodeDetailMenuItemLinkProps = (0, _public.useLinkProps)({
    ...(0, _link_to.getNodeDetailUrl)({
      nodeType,
      nodeId,
      from: nodeDetailFrom,
      to: currentTime
    })
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "infraNodeContextPopoverOpenAsPageButton",
    size: "xs",
    flush: "both"
  }, nodeDetailMenuItemLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.infra.nodeDetails.openAsPage",
    defaultMessage: "Open as page"
  }));
};
exports.LinkToNodeDetails = LinkToNodeDetails;