"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AssetDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _content = require("./content/content");
var _header = require("./header/header");
var _use_tab_switcher = require("./hooks/use_tab_switcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContentTemplate = ({
  header,
  body,
  renderMode
}) => {
  return renderMode.showInFlyout ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: renderMode.closeFlyout,
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, header), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, body)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, header, body);
};
const AssetDetails = ({
  node,
  currentTimeRange,
  activeTabId,
  overrides,
  onTabsStateChange,
  tabs = [],
  links = [],
  nodeType = 'host',
  renderMode = {
    showInFlyout: false
  }
}) => {
  return /*#__PURE__*/_react.default.createElement(_use_tab_switcher.TabSwitcherProvider, {
    initialActiveTabId: tabs.length > 0 ? activeTabId !== null && activeTabId !== void 0 ? activeTabId : tabs[0].id : undefined
  }, /*#__PURE__*/_react.default.createElement(ContentTemplate, {
    header: /*#__PURE__*/_react.default.createElement(_header.Header, {
      node: node,
      nodeType: nodeType,
      currentTimeRange: currentTimeRange,
      compact: renderMode.showInFlyout,
      tabs: tabs,
      links: links,
      overrides: overrides,
      onTabsStateChange: onTabsStateChange
    }),
    body: /*#__PURE__*/_react.default.createElement(_content.Content, {
      node: node,
      nodeType: nodeType,
      currentTimeRange: currentTimeRange,
      overrides: overrides,
      onTabsStateChange: onTabsStateChange
    }),
    renderMode: renderMode
  }));
};

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
exports.AssetDetails = AssetDetails;
var _default = AssetDetails;
exports.default = _default;