"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHttp = void 0;
var _infra_ml = require("../../../../../common/http_api/infra_ml");
var _fixtures = require("./fixtures");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHttp = params => {
  const http = {
    basePath: {
      prepend: _path => {
        return '';
      }
    },
    fetch: async path => {
      switch (path) {
        case '/api/infra/metadata':
          return _fixtures.metadataHttpResponse[params.mock]();
        case '/api/metrics/process_list':
          return _fixtures.processesHttpResponse[params.mock]();
        case '/api/metrics/process_list/chart':
          return _fixtures.processesChartHttpResponse.default();
        case '/api/metrics/snapshot':
          return _fixtures.snapshotAPItHttpResponse[params.mock]();
        case _infra_ml.INFA_ML_GET_METRICS_HOSTS_ANOMALIES_PATH:
          return _fixtures.anomaliesHttpResponse[params.mock]();
        default:
          return Promise.resolve({});
      }
    }
  };
  return http;
};
exports.getHttp = getHttp;