"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getXYVisualizationState = exports.LineChart = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BREAKDOWN_COLUMN_NAME = 'hosts_aggs_breakdown';
const HISTOGRAM_COLUMN_NAME = 'x_date_histogram';
const ACCESSOR = 'formula_accessor';
class LineChart {
  constructor(chartConfig, dataView, formulaAPI, options) {
    this.chartConfig = chartConfig;
    this.dataView = dataView;
    this.formulaAPI = formulaAPI;
    this.options = options;
  }
  getVisualizationType() {
    return 'lnsXY';
  }
  getLayers() {
    var _this$options, _this$chartConfig$lin;
    const baseLayer = {
      columnOrder: [BREAKDOWN_COLUMN_NAME, HISTOGRAM_COLUMN_NAME],
      columns: {
        ...(0, _utils.getBreakdownColumn)({
          columnName: BREAKDOWN_COLUMN_NAME,
          overrides: {
            sourceField: 'host.name',
            breakdownSize: (_this$options = this.options) === null || _this$options === void 0 ? void 0 : _this$options.breakdownSize
          }
        }),
        ...(0, _utils.getHistogramColumn)({
          columnName: HISTOGRAM_COLUMN_NAME,
          overrides: {
            sourceField: this.dataView.timeFieldName
          }
        })
      }
    };
    const dataLayer = this.formulaAPI.insertOrReplaceFormulaColumn(ACCESSOR, this.chartConfig.formula, baseLayer, this.dataView);
    if (!dataLayer) {
      throw new Error('Error generating the data layer for the chart');
    }
    return {
      [_utils.DEFAULT_LAYER_ID]: dataLayer,
      ...((_this$chartConfig$lin = this.chartConfig.lineChartConfig) === null || _this$chartConfig$lin === void 0 ? void 0 : _this$chartConfig$lin.extraLayers)
    };
  }
  getVisualizationState() {
    var _this$chartConfig$lin2;
    const extraVisualizationState = (_this$chartConfig$lin2 = this.chartConfig.lineChartConfig) === null || _this$chartConfig$lin2 === void 0 ? void 0 : _this$chartConfig$lin2.extraVisualizationState;
    return getXYVisualizationState({
      ...extraVisualizationState,
      layers: [{
        layerId: _utils.DEFAULT_LAYER_ID,
        seriesType: 'line',
        accessors: [ACCESSOR],
        yConfig: [],
        layerType: 'data',
        xAccessor: HISTOGRAM_COLUMN_NAME,
        splitAccessor: BREAKDOWN_COLUMN_NAME
      }, ...(extraVisualizationState !== null && extraVisualizationState !== void 0 && extraVisualizationState.layers ? extraVisualizationState === null || extraVisualizationState === void 0 ? void 0 : extraVisualizationState.layers : [])]
    });
  }
  getReferences() {
    var _this$chartConfig$lin3;
    const extraReference = (_this$chartConfig$lin3 = this.chartConfig.lineChartConfig) === null || _this$chartConfig$lin3 === void 0 ? void 0 : _this$chartConfig$lin3.extraReference;
    return [...(0, _utils.getDefaultReferences)(this.dataView, _utils.DEFAULT_LAYER_ID), ...(extraReference ? (0, _utils.getDefaultReferences)(this.dataView, extraReference) : [])];
  }
  getDataView() {
    return this.dataView;
  }
  getTitle() {
    var _ref, _this$options$title, _this$options2;
    return (_ref = (_this$options$title = (_this$options2 = this.options) === null || _this$options2 === void 0 ? void 0 : _this$options2.title) !== null && _this$options$title !== void 0 ? _this$options$title : this.chartConfig.title) !== null && _ref !== void 0 ? _ref : '';
  }
  getFilters() {
    var _this$dataView$id;
    return this.chartConfig.getFilters({
      id: (_this$dataView$id = this.dataView.id) !== null && _this$dataView$id !== void 0 ? _this$dataView$id : _utils.DEFAULT_LAYER_ID
    });
  }
}
exports.LineChart = LineChart;
const getXYVisualizationState = custom => ({
  legend: {
    isVisible: false,
    position: 'right',
    showSingleSeries: false
  },
  valueLabels: 'show',
  fittingFunction: 'Zero',
  curveType: 'LINEAR',
  yLeftScale: 'linear',
  axisTitlesVisibilitySettings: {
    x: false,
    yLeft: false,
    yRight: true
  },
  tickLabelsVisibilitySettings: {
    x: true,
    yLeft: true,
    yRight: true
  },
  labelsOrientation: {
    x: 0,
    yLeft: 0,
    yRight: 0
  },
  gridlinesVisibilitySettings: {
    x: true,
    yLeft: true,
    yRight: true
  },
  preferredSeriesType: 'line',
  valuesInLegend: false,
  emphasizeFitting: true,
  hideEndzones: true,
  ...custom
});
exports.getXYVisualizationState = getXYVisualizationState;