"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHistogramColumn = exports.getDefaultReferences = exports.getBreakdownColumn = exports.getAdhocDataView = exports.DEFAULT_LAYER_ID = exports.DEFAULT_AD_HOC_DATA_VIEW_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_LAYER_ID = 'layer1';
exports.DEFAULT_LAYER_ID = DEFAULT_LAYER_ID;
const DEFAULT_AD_HOC_DATA_VIEW_ID = 'infra_lens_ad_hoc_default';
exports.DEFAULT_AD_HOC_DATA_VIEW_ID = DEFAULT_AD_HOC_DATA_VIEW_ID;
const DEFAULT_BREAKDOWN_SIZE = 10;
const getHistogramColumn = ({
  columnName,
  overrides
}) => {
  return {
    [columnName]: {
      dataType: 'date',
      isBucketed: true,
      label: '@timestamp',
      operationType: 'date_histogram',
      scale: 'interval',
      sourceField: '@timestamp',
      ...overrides,
      params: {
        interval: 'auto',
        ...(overrides === null || overrides === void 0 ? void 0 : overrides.params)
      }
    }
  };
};
exports.getHistogramColumn = getHistogramColumn;
const getBreakdownColumn = ({
  columnName,
  overrides
}) => {
  const {
    breakdownSize = DEFAULT_BREAKDOWN_SIZE,
    sourceField
  } = overrides !== null && overrides !== void 0 ? overrides : {};
  return {
    [columnName]: {
      label: `Top ${breakdownSize} values of ${sourceField}`,
      dataType: 'string',
      operationType: 'terms',
      scale: 'ordinal',
      sourceField,
      isBucketed: true,
      params: {
        size: breakdownSize,
        orderBy: {
          type: 'alphabetical',
          fallback: false
        },
        orderDirection: 'asc',
        otherBucket: false,
        missingBucket: false,
        parentFormat: {
          id: 'terms'
        },
        include: [],
        exclude: [],
        includeIsRegex: false,
        excludeIsRegex: false
      }
    }
  };
};
exports.getBreakdownColumn = getBreakdownColumn;
const getDefaultReferences = (dataView, dataLayerId) => {
  var _dataView$id;
  return [{
    type: 'index-pattern',
    id: (_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : DEFAULT_AD_HOC_DATA_VIEW_ID,
    name: `indexpattern-datasource-layer-${dataLayerId}`
  }];
};
exports.getDefaultReferences = getDefaultReferences;
const getAdhocDataView = dataViewSpec => {
  var _dataViewSpec$id;
  return {
    [(_dataViewSpec$id = dataViewSpec.id) !== null && _dataViewSpec$id !== void 0 ? _dataViewSpec$id : DEFAULT_AD_HOC_DATA_VIEW_ID]: {
      ...dataViewSpec
    }
  };
};
exports.getAdhocDataView = getAdhocDataView;