"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensAttributesBuilder = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _data_view_cache = require("./data_view_cache");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LensAttributesBuilder {
  constructor(visualization) {
    (0, _defineProperty2.default)(this, "dataViewCache", void 0);
    this.visualization = visualization;
    this.dataViewCache = _data_view_cache.DataViewCache.getInstance();
  }
  build() {
    return {
      title: this.visualization.getTitle(),
      visualizationType: this.visualization.getVisualizationType(),
      references: this.visualization.getReferences(),
      state: {
        datasourceStates: {
          formBased: {
            layers: this.visualization.getLayers()
          }
        },
        internalReferences: this.visualization.getReferences(),
        filters: this.visualization.getFilters(),
        query: {
          language: 'kuery',
          query: ''
        },
        visualization: this.visualization.getVisualizationState(),
        adHocDataViews: (0, _utils.getAdhocDataView)(this.dataViewCache.getSpec(this.visualization.getDataView()))
      }
    };
  }
}
exports.LensAttributesBuilder = LensAttributesBuilder;