"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskSpaceUsageLineChart = exports.diskSpaceUsage = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const diskSpaceUsageLineChart = {
  extraVisualizationState: {
    yLeftExtent: {
      mode: 'custom',
      lowerBound: 0,
      upperBound: 1
    }
  }
};
exports.diskSpaceUsageLineChart = diskSpaceUsageLineChart;
const diskSpaceUsage = {
  title: 'Disk Space Usage',
  formula: {
    formula: 'average(system.filesystem.used.pct)',
    format: {
      id: 'percent',
      params: {
        decimals: 0
      }
    }
  },
  getFilters: _utils.getFilters,
  lineChartConfig: diskSpaceUsageLineChart
};
exports.diskSpaceUsage = diskSpaceUsage;