"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _log_view_state = require("../observability_logs/log_view_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = (core, pluginStart, params) => {
  const toastsService = core.notifications.toasts;
  const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
    history: params.history,
    useHash: false,
    useHashQuery: false
  });
  const logView = (0, _log_view_state.getLogViewReferenceFromUrl)({
    toastsService,
    urlStateStorage
  });
  pluginStart.locators.logsLocator.navigate({
    ...(logView ? {
      logView
    } : {})
  }, {
    replace: true
  });
  return () => true;
};
exports.renderApp = renderApp;