"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatReason = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _metrics = require("../../../common/alerting/metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatReason = ({
  fields
}) => {
  var _fields$ALERT_REASON;
  const reason = (_fields$ALERT_REASON = fields[_ruleDataUtils.ALERT_REASON]) !== null && _fields$ALERT_REASON !== void 0 ? _fields$ALERT_REASON : '-';
  const link = _metrics.LINK_TO_METRICS_EXPLORER; // TODO https://github.com/elastic/kibana/issues/106497 & https://github.com/elastic/kibana/issues/106958

  return {
    reason,
    link
  };
};
exports.formatReason = formatReason;