"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/charts-plugin/public");
var _lodash = require("lodash");
var _get_chart_theme = require("../../../utils/get_chart_theme");
var _use_is_dark_mode = require("../../../hooks/use_is_dark_mode");
var _color_palette = require("../../../../common/color_palette");
var _series_chart = require("../../../pages/metrics/metrics_explorer/components/series_chart");
var _use_metrics_explorer_options = require("../../../pages/metrics/metrics_explorer/hooks/use_metrics_explorer_options");
var _create_formatter_for_metric = require("../../../pages/metrics/metrics_explorer/components/helpers/create_formatter_for_metric");
var _calculate_domain = require("../../../pages/metrics/metrics_explorer/components/helpers/calculate_domain");
var _use_metrics_explorer_chart_data = require("../hooks/use_metrics_explorer_chart_data");
var _get_metric_id = require("../../../pages/metrics/metrics_explorer/components/helpers/get_metric_id");
var _use_kibana = require("../../../hooks/use_kibana");
var _criterion_preview_chart = require("../../common/criterion_preview_chart/criterion_preview_chart");
var _threshold_annotations = require("../../common/criterion_preview_chart/threshold_annotations");
var _i18n_strings = require("../i18n_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpressionChart = ({
  expression,
  derivedIndexPattern,
  annotations,
  chartType = _use_metrics_explorer_options.MetricsExplorerChartType.bar,
  filterQuery,
  groupBy,
  hideTitle = false,
  source,
  timeRange
}) => {
  var _expression$warningTh, _expression$warningTh2;
  const {
    charts
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const isDarkMode = (0, _use_is_dark_mode.useIsDarkMode)();
  const {
    isLoading,
    data
  } = (0, _use_metrics_explorer_chart_data.useMetricsExplorerChartData)(expression, derivedIndexPattern, source, filterQuery, groupBy, timeRange);
  const chartRef = (0, _react.useRef)(null);
  const handleCursorUpdate = (0, _public.useActiveCursor)(charts.activeCursor, chartRef, {
    isDateHistogram: true
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.LoadingState, null);
  }
  if (!data) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.NoDataState, null);
  }
  const firstSeries = (0, _lodash.first)((0, _lodash.first)(data.pages).series);
  // Creating a custom series where the ID is changed to 0
  // so that we can get a proper domain
  if (!firstSeries || !firstSeries.rows || firstSeries.rows.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.NoDataState, null);
  }
  const firstTimestamp = (0, _lodash.first)(firstSeries.rows).timestamp;
  const lastTimestamp = (0, _lodash.last)(firstSeries.rows).timestamp;
  const metric = {
    field: expression.metric,
    aggregation: expression.aggType,
    color: _color_palette.Color.color0
  };
  if (metric.aggregation === 'custom') {
    metric.label = expression.label || _i18n_strings.CUSTOM_EQUATION;
  }
  const dateFormatter = firstTimestamp == null || lastTimestamp == null ? value => `${value}` : (0, _charts.niceTimeFormatter)([firstTimestamp, lastTimestamp]);
  const criticalThresholds = expression.threshold.slice().sort();
  const warningThresholds = (_expression$warningTh = (_expression$warningTh2 = expression.warningThreshold) === null || _expression$warningTh2 === void 0 ? void 0 : _expression$warningTh2.slice().sort()) !== null && _expression$warningTh !== void 0 ? _expression$warningTh : [];
  const thresholds = [...criticalThresholds, ...warningThresholds].sort();
  const series = {
    ...firstSeries,
    rows: firstSeries.rows.map(row => {
      const newRow = {
        ...row
      };
      thresholds.forEach((thresholdValue, index) => {
        newRow[(0, _get_metric_id.getMetricId)(metric, `threshold_${index}`)] = thresholdValue;
      });
      return newRow;
    })
  };
  const dataDomain = (0, _calculate_domain.calculateDomain)(series, [metric], false);
  const domain = {
    max: Math.max(dataDomain.max, (0, _lodash.last)(thresholds) || dataDomain.max) * 1.1,
    // add 10% headroom.
    min: Math.min(dataDomain.min, (0, _lodash.first)(thresholds) || dataDomain.min) * 0.9 // add 10% floor,
  };

  if (domain.min === (0, _lodash.first)(expression.threshold)) {
    domain.min = domain.min * 0.9;
  }
  const {
    timeSize,
    timeUnit
  } = expression;
  const timeLabel = _criterion_preview_chart.TIME_LABELS[timeUnit];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.ChartContainer, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    ref: chartRef
  }, /*#__PURE__*/_react.default.createElement(_series_chart.MetricExplorerSeriesChart, {
    type: chartType,
    metric: metric,
    id: "0",
    series: series,
    stack: false
  }), /*#__PURE__*/_react.default.createElement(_threshold_annotations.ThresholdAnnotations, {
    comparator: expression.comparator,
    threshold: expression.threshold,
    sortedThresholds: criticalThresholds,
    color: _color_palette.Color.color1,
    id: "critical",
    firstTimestamp: firstTimestamp,
    lastTimestamp: lastTimestamp,
    domain: domain
  }), expression.warningComparator && expression.warningThreshold && /*#__PURE__*/_react.default.createElement(_threshold_annotations.ThresholdAnnotations, {
    comparator: expression.warningComparator,
    threshold: expression.warningThreshold,
    sortedThresholds: warningThresholds,
    color: _color_palette.Color.color5,
    id: "warning",
    firstTimestamp: firstTimestamp,
    lastTimestamp: lastTimestamp,
    domain: domain
  }), annotations, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: (0, _create_formatter_for_metric.createFormatterForMetric)(metric),
    domain: domain
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, _criterion_preview_chart.tooltipProps), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onPointerUpdate: handleCursorUpdate,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    theme: (0, _get_chart_theme.getChartTheme)(isDarkMode)
  }))), !hideTitle && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    }
  }, series.id !== 'ALL' ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alerts.dataTimeRangeLabelWithGrouping",
    defaultMessage: "Last {lookback} {timeLabel} of data for {id}",
    values: {
      id: series.id,
      timeLabel,
      lookback: timeSize * 20
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alerts.dataTimeRangeLabel",
    defaultMessage: "Last {lookback} {timeLabel}",
    values: {
      timeLabel,
      lookback: timeSize * 20
    }
  }))));
};
exports.ExpressionChart = ExpressionChart;