"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeTypes = exports.defaultExpression = exports.default = exports.Expression = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _anomaly_threshold = require("@kbn/ml-anomaly-utils/anomaly_threshold");
var _metrics_source = require("../../../containers/metrics_source");
var _inventory_models = require("../../../../common/inventory_models");
var _subscription_splash_content = require("../../../components/subscription_splash_content");
var _infra_ml_capabilities = require("../../../containers/ml/infra_ml_capabilities");
var _use_kibana_space = require("../../../hooks/use_kibana_space");
var _influencer_filter = require("./influencer_filter");
var _node_type = require("./node_type");
var _severity_threshold = require("./severity_threshold");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultExpression = {
  metric: 'memory_usage',
  threshold: _anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR,
  nodeType: 'hosts',
  influencerFilter: undefined
};
exports.defaultExpression = defaultExpression;
const Expression = props => {
  var _ruleParams$influence, _ruleParams$influence2, _ruleParams$nodeType, _ruleParams$metric, _ruleParams$threshold, _ruleParams$influence3, _ruleParams$influence4;
  const {
    hasInfraMLCapabilities,
    isLoading: isLoadingMLCapabilities
  } = (0, _infra_ml_capabilities.useInfraMLCapabilities)();
  const {
    space
  } = (0, _use_kibana_space.useActiveKibanaSpace)();
  const {
    setRuleParams,
    ruleParams,
    ruleInterval,
    metadata
  } = props;
  const {
    source,
    createDerivedIndexPattern
  } = (0, _metrics_source.useSourceContext)();
  const derivedIndexPattern = (0, _react.useMemo)(() => createDerivedIndexPattern(), [createDerivedIndexPattern]);
  const [influencerFieldName, updateInfluencerFieldName] = (0, _react.useState)((_ruleParams$influence = (_ruleParams$influence2 = ruleParams.influencerFilter) === null || _ruleParams$influence2 === void 0 ? void 0 : _ruleParams$influence2.fieldName) !== null && _ruleParams$influence !== void 0 ? _ruleParams$influence : 'host.name');
  (0, _react.useEffect)(() => {
    setRuleParams('hasInfraMLCapabilities', hasInfraMLCapabilities);
  }, [setRuleParams, hasInfraMLCapabilities]);
  (0, _react.useEffect)(() => {
    if (ruleParams.influencerFilter) {
      setRuleParams('influencerFilter', {
        ...ruleParams.influencerFilter,
        fieldName: influencerFieldName
      });
    }
  }, [influencerFieldName, ruleParams, setRuleParams]);
  const updateInfluencerFieldValue = (0, _react.useCallback)(value => {
    if (value) {
      setRuleParams('influencerFilter', {
        ...ruleParams.influencerFilter,
        fieldValue: value
      });
    } else {
      setRuleParams('influencerFilter', undefined);
    }
  }, [setRuleParams, ruleParams]);
  (0, _react.useEffect)(() => {
    setRuleParams('alertInterval', ruleInterval);
  }, [setRuleParams, ruleInterval]);
  const updateNodeType = (0, _react.useCallback)(nt => {
    setRuleParams('nodeType', nt);
  }, [setRuleParams]);
  const updateMetric = (0, _react.useCallback)(metric => {
    setRuleParams('metric', metric);
  }, [setRuleParams]);
  const updateSeverityThreshold = (0, _react.useCallback)(threshold => {
    setRuleParams('threshold', threshold);
  }, [setRuleParams]);
  const prefillNodeType = (0, _react.useCallback)(() => {
    const md = metadata;
    if (md && md.nodeType) {
      var _getMLNodeTypeFromInv;
      setRuleParams('nodeType', (_getMLNodeTypeFromInv = getMLNodeTypeFromInventoryNodeType(md.nodeType)) !== null && _getMLNodeTypeFromInv !== void 0 ? _getMLNodeTypeFromInv : defaultExpression.nodeType);
    } else {
      setRuleParams('nodeType', defaultExpression.nodeType);
    }
  }, [metadata, setRuleParams]);
  const prefillMetric = (0, _react.useCallback)(() => {
    const md = metadata;
    if (md && md.metric) {
      var _getMLMetricFromInven;
      setRuleParams('metric', (_getMLMetricFromInven = getMLMetricFromInventoryMetric(md.metric.type)) !== null && _getMLMetricFromInven !== void 0 ? _getMLMetricFromInven : defaultExpression.metric);
    } else {
      setRuleParams('metric', defaultExpression.metric);
    }
  }, [metadata, setRuleParams]);
  (0, _react.useEffect)(() => {
    if (!ruleParams.nodeType) {
      prefillNodeType();
    }
    if (!ruleParams.threshold) {
      setRuleParams('threshold', defaultExpression.threshold);
    }
    if (!ruleParams.metric) {
      prefillMetric();
    }
    if (!ruleParams.sourceId) {
      setRuleParams('sourceId', (source === null || source === void 0 ? void 0 : source.id) || 'default');
    }
    if (!ruleParams.spaceId) {
      setRuleParams('spaceId', (space === null || space === void 0 ? void 0 : space.id) || 'default');
    }
  }, [metadata, derivedIndexPattern, defaultExpression, source, space]); // eslint-disable-line react-hooks/exhaustive-deps

  if (isLoadingMLCapabilities) return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  });
  if (!hasInfraMLCapabilities) return /*#__PURE__*/_react.default.createElement(_subscription_splash_content.SubscriptionSplashPrompt, null);
  return (
    /*#__PURE__*/
    // https://github.com/elastic/kibana/issues/89506
    _react.default.createElement(_common.EuiThemeProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.alertFlyout.conditions",
      defaultMessage: "Conditions"
    }))), /*#__PURE__*/_react.default.createElement(StyledExpression, null, /*#__PURE__*/_react.default.createElement(StyledExpressionRow, null, /*#__PURE__*/_react.default.createElement(_node_type.NodeTypeExpression, {
      options: nodeTypes,
      value: (_ruleParams$nodeType = ruleParams.nodeType) !== null && _ruleParams$nodeType !== void 0 ? _ruleParams$nodeType : defaultExpression.nodeType,
      onChange: updateNodeType
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'xs'
    }), /*#__PURE__*/_react.default.createElement(StyledExpressionRow, null, /*#__PURE__*/_react.default.createElement(StyledExpression, null, /*#__PURE__*/_react.default.createElement(_public.WhenExpression, {
      aggType: (_ruleParams$metric = ruleParams.metric) !== null && _ruleParams$metric !== void 0 ? _ruleParams$metric : defaultExpression.metric,
      onChangeSelectedAggType: updateMetric,
      customAggTypesOptions: {
        memory_usage: {
          text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.anomalyJobs.memoryUsage', {
            defaultMessage: 'Memory usage'
          }),
          fieldRequired: false,
          value: 'memory_usage',
          validNormalizedTypes: []
        },
        network_in: {
          text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.anomalyJobs.networkIn', {
            defaultMessage: 'Network in'
          }),
          fieldRequired: false,
          validNormalizedTypes: [],
          value: 'network_in'
        },
        network_out: {
          text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.anomalyJobs.networkOut', {
            defaultMessage: 'Network out'
          }),
          fieldRequired: false,
          validNormalizedTypes: [],
          value: 'network_out'
        }
      }
    })), /*#__PURE__*/_react.default.createElement(StyledExpression, null, /*#__PURE__*/_react.default.createElement(_severity_threshold.SeverityThresholdExpression, {
      value: (_ruleParams$threshold = ruleParams.threshold) !== null && _ruleParams$threshold !== void 0 ? _ruleParams$threshold : _anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL,
      onChange: updateSeverityThreshold
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'm'
    }), /*#__PURE__*/_react.default.createElement(_influencer_filter.InfluencerFilter, {
      derivedIndexPattern: derivedIndexPattern,
      nodeType: ruleParams.nodeType,
      fieldName: influencerFieldName,
      fieldValue: (_ruleParams$influence3 = (_ruleParams$influence4 = ruleParams.influencerFilter) === null || _ruleParams$influence4 === void 0 ? void 0 : _ruleParams$influence4.fieldValue) !== null && _ruleParams$influence3 !== void 0 ? _ruleParams$influence3 : '',
      onChangeFieldName: updateInfluencerFieldName,
      onChangeFieldValue: updateInfluencerFieldValue
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'm'
    }))
  );
};

// required for dynamic import
// eslint-disable-next-line import/no-default-export
exports.Expression = Expression;
var _default = (0, _metrics_source.withSourceProvider)(Expression)('default');
exports.default = _default;
const StyledExpressionRow = (0, _common.euiStyled)(_eui.EuiFlexGroup)`
  display: flex;
  flex-wrap: wrap;
  margin: 0 -4px;
`;
const StyledExpression = _common.euiStyled.div`
  padding: 0 4px;
`;
const getDisplayNameForType = type => {
  const inventoryModel = (0, _inventory_models.findInventoryModel)(type);
  return inventoryModel.displayName;
};
const nodeTypes = {
  hosts: {
    text: getDisplayNameForType('host'),
    value: 'hosts'
  },
  k8s: {
    text: getDisplayNameForType('pod'),
    value: 'k8s'
  }
};
exports.nodeTypes = nodeTypes;
const getMLMetricFromInventoryMetric = metric => {
  switch (metric) {
    case 'memory':
      return 'memory_usage';
    case 'tx':
      return 'network_out';
    case 'rx':
      return 'network_in';
    default:
      return null;
  }
};
const getMLNodeTypeFromInventoryNodeType = nodeType => {
  switch (nodeType) {
    case 'host':
      return 'hosts';
    case 'pod':
      return 'k8s';
    default:
      return null;
  }
};