"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SourceStatusWrapper = exports.ExpressionLike = exports.ExpressionEditor = exports.Editor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _types = require("../../../../../common/alerting/logs/log_threshold/types");
var _runtime_types = require("../../../../../common/runtime_types");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_log_view = require("../../../../hooks/use_log_view");
var _group_by_expression = require("../../../common/group_by_expression/group_by_expression");
var _validation = require("../../validation");
var _criteria = require("./criteria");
var _threshold = require("./threshold");
var _type_switcher = require("./type_switcher");
var _log_view_switcher = require("./log_view_switcher");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BASE_EXPRESSION = {
  timeSize: 5,
  timeUnit: 'm'
};
const DEFAULT_FIELD = 'log.level';
const createDefaultCriterion = (availableFields, value) => availableFields.some(availableField => availableField.name === DEFAULT_FIELD) ? {
  field: DEFAULT_FIELD,
  comparator: _types.Comparator.EQ,
  value
} : {
  field: undefined,
  comparator: undefined,
  value: undefined
};
const createDefaultCountRuleParams = (availableFields, logView) => ({
  ...DEFAULT_BASE_EXPRESSION,
  logView,
  count: {
    value: 75,
    comparator: _types.Comparator.GT
  },
  criteria: [createDefaultCriterion(availableFields, 'error')]
});
const createDefaultRatioRuleParams = (availableFields, logView) => ({
  ...DEFAULT_BASE_EXPRESSION,
  logView,
  count: {
    value: 2,
    comparator: _types.Comparator.GT
  },
  criteria: [[createDefaultCriterion(availableFields, 'error')], [createDefaultCriterion(availableFields, 'warning')]]
});
const ExpressionEditor = props => {
  var _props$metadata$isInt, _props$metadata;
  const isInternal = (_props$metadata$isInt = (_props$metadata = props.metadata) === null || _props$metadata === void 0 ? void 0 : _props$metadata.isInternal) !== null && _props$metadata$isInt !== void 0 ? _props$metadata$isInt : false;
  const {
    services: {
      logViews
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)(); // injected during alert registration

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isInternal ? /*#__PURE__*/_react.default.createElement(SourceStatusWrapper, props, /*#__PURE__*/_react.default.createElement(Editor, props)) : /*#__PURE__*/_react.default.createElement(_use_log_view.LogViewProvider, {
    logViews: logViews.client
  }, /*#__PURE__*/_react.default.createElement(SourceStatusWrapper, props, /*#__PURE__*/_react.default.createElement(Editor, props))));
};
exports.ExpressionEditor = ExpressionEditor;
const SourceStatusWrapper = ({
  children
}) => {
  const {
    load,
    isLoading,
    hasFailedLoading,
    isUninitialized
  } = (0, _use_log_view.useLogViewContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading || isUninitialized ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : hasFailedLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.infra.logs.alertFlyout.sourceStatusError', {
      defaultMessage: 'Sorry, there was a problem loading field information'
    }),
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraSourceStatusWrapperTryAgainButton",
    onClick: load,
    iconType: "refresh"
  }, _i18n.i18n.translate('xpack.infra.logs.alertFlyout.sourceStatusErrorTryAgain', {
    defaultMessage: 'Try again'
  }))) : children);
};
exports.SourceStatusWrapper = SourceStatusWrapper;
const Editor = props => {
  var _ruleParams$count, _ruleParams$count2;
  const {
    setRuleParams,
    ruleParams,
    errors
  } = props;
  const [hasSetDefaults, setHasSetDefaults] = (0, _react.useState)(false);
  const {
    logViewReference,
    resolvedLogView
  } = (0, _use_log_view.useLogViewContext)();
  if (logViewReference.type !== 'log-view-reference') {
    throw new Error('The Log Threshold rule type only supports persisted Log Views');
  }
  const {
    criteria: criteriaErrors,
    threshold: thresholdErrors,
    timeSizeUnit: timeSizeUnitErrors,
    timeWindowSize: timeWindowSizeErrors
  } = (0, _react.useMemo)(() => (0, _runtime_types.decodeOrThrow)(_validation.errorsRT)(errors), [errors]);
  const supportedFields = (0, _react.useMemo)(() => {
    if (resolvedLogView !== null && resolvedLogView !== void 0 && resolvedLogView.fields) {
      return resolvedLogView.fields.filter(field => {
        return (field.type === 'string' || field.type === 'number') && field.searchable;
      });
    } else {
      return [];
    }
  }, [resolvedLogView]);
  const groupByFields = (0, _react.useMemo)(() => {
    if (resolvedLogView !== null && resolvedLogView !== void 0 && resolvedLogView.fields) {
      return resolvedLogView.fields.filter(field => {
        return field.type === 'string' && field.aggregatable;
      });
    } else {
      return [];
    }
  }, [resolvedLogView]);
  const updateThreshold = (0, _react.useCallback)(thresholdParams => {
    const nextThresholdParams = {
      ...ruleParams.count,
      ...thresholdParams
    };
    setRuleParams('count', nextThresholdParams);
  }, [ruleParams.count, setRuleParams]);
  const updateCriteria = (0, _react.useCallback)(criteria => {
    setRuleParams('criteria', criteria);
  }, [setRuleParams]);
  const updateTimeSize = (0, _react.useCallback)(ts => {
    setRuleParams('timeSize', ts);
  }, [setRuleParams]);
  const updateTimeUnit = (0, _react.useCallback)(tu => {
    if (_types.timeUnitRT.is(tu)) {
      setRuleParams('timeUnit', tu);
    }
  }, [setRuleParams]);
  const updateGroupBy = (0, _react.useCallback)(groups => {
    setRuleParams('groupBy', groups);
  }, [setRuleParams]);
  const defaultCountAlertParams = (0, _react.useMemo)(() => createDefaultCountRuleParams(supportedFields, logViewReference), [supportedFields, logViewReference]);
  const updateType = (0, _react.useCallback)(type => {
    const defaults = type === 'count' ? defaultCountAlertParams : createDefaultRatioRuleParams(supportedFields, logViewReference);
    // Reset properties that don't make sense switching from one context to the other
    setRuleParams('count', defaults.count);
    setRuleParams('criteria', defaults.criteria);
  }, [defaultCountAlertParams, setRuleParams, supportedFields, logViewReference]);
  (0, _useMount.default)(() => {
    const newAlertParams = {
      ...defaultCountAlertParams,
      ...ruleParams
    };
    for (const [key, value] of Object.entries(newAlertParams)) {
      setRuleParams(key, value);
    }
    setHasSetDefaults(true);
  });
  const shouldShowGroupByOptimizationWarning = (0, _react.useMemo)(() => {
    const hasSetGroupBy = ruleParams.groupBy && ruleParams.groupBy.length > 0;
    return hasSetGroupBy && ruleParams.count && !(0, _types.isOptimizableGroupedThreshold)(ruleParams.count.comparator, ruleParams.count.value);
  }, [ruleParams]);

  // Wait until the alert param defaults have been set
  if (!hasSetDefaults) return null;
  const criteriaComponent = ruleParams.criteria ? /*#__PURE__*/_react.default.createElement(_criteria.Criteria, {
    fields: supportedFields,
    criteria: ruleParams.criteria,
    defaultCriterion: defaultCountAlertParams.criteria[0],
    errors: criteriaErrors,
    ruleParams: ruleParams,
    logViewReference: logViewReference,
    updateCriteria: updateCriteria
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resolvedLogView && /*#__PURE__*/_react.default.createElement(_log_view_switcher.LogViewSwitcher, {
    logView: resolvedLogView
  }), /*#__PURE__*/_react.default.createElement(_type_switcher.TypeSwitcher, {
    criteria: ruleParams.criteria || [],
    updateType: updateType
  }), ruleParams.criteria && !(0, _types.isRatioRule)(ruleParams.criteria) && criteriaComponent, /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
    comparator: (_ruleParams$count = ruleParams.count) === null || _ruleParams$count === void 0 ? void 0 : _ruleParams$count.comparator,
    value: (_ruleParams$count2 = ruleParams.count) === null || _ruleParams$count2 === void 0 ? void 0 : _ruleParams$count2.value,
    updateThreshold: updateThreshold,
    errors: thresholdErrors
  }), /*#__PURE__*/_react.default.createElement(_public.ForLastExpression, {
    timeWindowSize: ruleParams.timeSize,
    timeWindowUnit: ruleParams.timeUnit,
    onChangeWindowSize: updateTimeSize,
    onChangeWindowUnit: updateTimeUnit,
    errors: {
      timeWindowSize: timeWindowSizeErrors,
      timeSizeUnit: timeSizeUnitErrors
    }
  }), /*#__PURE__*/_react.default.createElement(_group_by_expression.GroupByExpression, {
    selectedGroups: ruleParams.groupBy,
    onChange: updateGroupBy,
    fields: groupByFields
  }), ruleParams.criteria && (0, _types.isRatioRule)(ruleParams.criteria) && criteriaComponent, shouldShowGroupByOptimizationWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, _i18n.i18n.translate('xpack.infra.logs.alertFlyout.groupByOptimizationWarning', {
    defaultMessage: 'When setting a "group by" we highly recommend using the "{comparator}" comparator for your threshold. This can lead to significant performance improvements.',
    values: {
      comparator: _types.Comparator.GT
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};

// required for dynamic import
// eslint-disable-next-line import/no-default-export
exports.Editor = Editor;
var _default = ExpressionEditor; // NOTE: Temporary until EUI allow empty values in EuiExpression
// components.
exports.default = _default;
const ExpressionLike = ({
  text
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "euiExpression euiExpression-isUppercase euiExpression--success"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "euiExpression__description"
  }, text));
};
exports.ExpressionLike = ExpressionLike;