"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricExpression = exports.ClosablePopoverTitle = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _get_custom_metric_label = require("../../../../common/formatters/get_custom_metric_label");
var _snapshot_api = require("../../../../common/http_api/snapshot_api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGGREGATION_LABELS = {
  ['avg']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.avg', {
    defaultMessage: 'Average'
  }),
  ['max']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.max', {
    defaultMessage: 'Max'
  }),
  ['min']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.min', {
    defaultMessage: 'Min'
  }),
  ['rate']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.rate', {
    defaultMessage: 'Rate'
  })
};
const aggregationOptions = _snapshot_api.SNAPSHOT_CUSTOM_AGGREGATIONS.map(k => ({
  text: AGGREGATION_LABELS[k],
  value: k
}));
const MetricExpression = ({
  metric,
  metrics,
  customMetric,
  fields,
  errors,
  onChange,
  onChangeCustom,
  popupPosition
}) => {
  var _errors$metric;
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [customMetricTabOpen, setCustomMetricTabOpen] = (0, _react.useState)((metric === null || metric === void 0 ? void 0 : metric.value) === 'custom');
  const [selectedOption, setSelectedOption] = (0, _react.useState)(metric === null || metric === void 0 ? void 0 : metric.value);
  const [fieldDisplayedCustomLabel, setFieldDisplayedCustomLabel] = (0, _react.useState)(customMetric === null || customMetric === void 0 ? void 0 : customMetric.label);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const firstFieldOption = {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.metric.selectFieldLabel', {
      defaultMessage: 'Select a metric'
    }),
    value: ''
  };
  const fieldOptions = (0, _react.useMemo)(() => fields.filter(f => f.aggregatable && f.type === 'number' && !((customMetric === null || customMetric === void 0 ? void 0 : customMetric.field) === f.name)).map(f => ({
    label: f.name
  })), [fields, customMetric === null || customMetric === void 0 ? void 0 : customMetric.field]);
  const expressionDisplayValue = (0, _react.useMemo)(() => {
    return customMetricTabOpen ? (customMetric === null || customMetric === void 0 ? void 0 : customMetric.field) && (0, _get_custom_metric_label.getCustomMetricLabel)(customMetric) : (metric === null || metric === void 0 ? void 0 : metric.text) || firstFieldOption.text;
  }, [customMetricTabOpen, metric, customMetric, firstFieldOption]);
  const onChangeTab = (0, _react.useCallback)(id => {
    if (id === 'metric-popover-custom') {
      setCustomMetricTabOpen(true);
      onChange('custom');
    } else {
      setCustomMetricTabOpen(false);
      onChange(selectedOption);
    }
  }, [setCustomMetricTabOpen, onChange, selectedOption]);
  const onAggregationChange = (0, _react.useCallback)(e => {
    const value = e.target.value;
    const aggValue = _snapshot_api.SnapshotCustomAggregationRT.is(value) ? value : 'avg';
    const newCustomMetric = {
      ...customMetric,
      aggregation: aggValue
    };
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(newCustomMetric)) onChangeCustom(newCustomMetric);
  }, [customMetric, onChangeCustom]);
  const onFieldChange = (0, _react.useCallback)(selectedOptions => {
    const newCustomMetric = {
      ...customMetric,
      field: selectedOptions[0].label
    };
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(newCustomMetric)) onChangeCustom(newCustomMetric);
  }, [customMetric, onChangeCustom]);
  const debouncedOnChangeCustom = (0, _lodash.debounce)(onChangeCustom, 500);
  const onLabelChange = (0, _react.useCallback)(e => {
    setFieldDisplayedCustomLabel(e.target.value);
    const newCustomMetric = {
      ...customMetric,
      label: e.target.value
    };
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(newCustomMetric)) debouncedOnChangeCustom(newCustomMetric);
  }, [customMetric, debouncedOnChangeCustom]);
  const availablefieldsOptions = metrics.map(m => {
    return {
      label: m.text,
      value: m.value
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "metricPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.metric.whenLabel', {
        defaultMessage: 'When'
      }),
      value: expressionDisplayValue,
      isActive: Boolean(popoverOpen || errors.metric && errors.metric.length > 0),
      onClick: () => {
        setPopoverOpen(true);
      },
      color: (_errors$metric = errors.metric) !== null && _errors$metric !== void 0 && _errors$metric.length ? 'danger' : 'success'
    }),
    isOpen: popoverOpen,
    closePopover: () => {
      setPopoverOpen(false);
    },
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downRight',
    zIndex: 8000
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 620
    }
  }, /*#__PURE__*/_react.default.createElement(ClosablePopoverTitle, {
    onClose: () => setPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.expression.metric.popoverTitle",
    defaultMessage: "Metric"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: "Metric type",
    options: [{
      id: 'metric-popover-default',
      label: 'Default metric'
    }, {
      id: 'metric-popover-custom',
      label: 'Custom metric'
    }],
    idSelected: customMetricTabOpen ? 'metric-popover-custom' : 'metric-popover-default',
    onChange: onChangeTab
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), customMetricTabOpen ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraMetricExpressionSelect",
    onChange: onAggregationChange,
    value: (customMetric === null || customMetric === void 0 ? void 0 : customMetric.aggregation) || 'avg',
    options: aggregationOptions,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.infra.waffle.customMetrics.of', {
    defaultMessage: 'of'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.fieldPlaceholder', {
      defaultMessage: 'Select a field'
    }),
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: customMetric !== null && customMetric !== void 0 && customMetric.field ? [{
      label: customMetric.field
    }] : [],
    options: fieldOptions,
    onChange: onFieldChange,
    isClearable: false,
    isInvalid: errors.metric.length > 0
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.waffle.alerting.customMetrics.labelLabel', {
      defaultMessage: 'Metric name (optional)'
    }),
    display: "rowCompressed",
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.infra.waffle.alerting.customMetrics.helpText', {
      defaultMessage: 'Choose a name to help identify your custom metric. Defaults to "<function> of <field name>".'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "infraMetricExpressionFieldText",
    name: "label",
    placeholder: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.labelPlaceholder', {
      defaultMessage: 'Choose a name to appear in the "Metric" dropdown'
    }),
    value: fieldDisplayedCustomLabel,
    fullWidth: true,
    onChange: onLabelChange
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "actOf__metricContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": "availablefieldsOptionsComboBox",
    isInvalid: errors.metric.length > 0,
    placeholder: firstFieldOption.text,
    options: availablefieldsOptions,
    noSuggestions: !availablefieldsOptions.length,
    selectedOptions: metric ? availablefieldsOptions.filter(a => a.value === metric.value) : [],
    renderOption: o => o.label,
    onChange: selectedOptions => {
      if (selectedOptions.length > 0) {
        onChange(selectedOptions[0].value);
        setSelectedOption(selectedOptions[0].value);
      } else {
        onChange();
      }
    }
  }))))));
};
exports.MetricExpression = MetricExpression;
const ClosablePopoverTitle = ({
  children,
  onClose
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel', {
      defaultMessage: 'Close'
    }),
    onClick: () => onClose()
  }))));
};
exports.ClosablePopoverTitle = ClosablePopoverTitle;