"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceStateKeyInQueryString = exports.replaceLogViewInQueryString = exports.replaceLogPositionInQueryString = exports.replaceLogFilterInQueryString = exports.getTimeRangeStartFromTime = exports.getTimeRangeEndFromTime = exports.defaultLogViewKey = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
var _rison = require("@kbn/rison");
var _queryString = require("query-string");
var _moment = _interopRequireDefault(require("moment"));
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultLogViewKey = 'logView';
exports.defaultLogViewKey = defaultLogViewKey;
const encodeRisonUrlState = state => (0, _rison.encode)(state);

// Used by linkTo components
const replaceLogPositionInQueryString = time => Number.isNaN(time) || time == null ? value => value : replaceStateKeyInQueryString(_.defaultPositionStateKey, {
  position: {
    time,
    tiebreaker: 0
  }
});

// NOTE: Used by link-to components
exports.replaceLogPositionInQueryString = replaceLogPositionInQueryString;
const replaceLogViewInQueryString = logViewReference => replaceStateKeyInQueryString(defaultLogViewKey, logViewReference);
exports.replaceLogViewInQueryString = replaceLogViewInQueryString;
const replaceStateKeyInQueryString = (stateKey, urlState) => queryString => {
  const previousQueryValues = (0, _queryString.parse)(queryString, {
    sort: false
  });
  const newValue = typeof urlState === 'undefined' ? previousQueryValues : {
    ...previousQueryValues,
    [stateKey]: encodeRisonUrlState(urlState)
  };
  return (0, _queryString.stringify)(_common.url.encodeQuery(newValue), {
    sort: false,
    encode: false
  });
};
exports.replaceStateKeyInQueryString = replaceStateKeyInQueryString;
const replaceLogFilterInQueryString = (query, time, timeRange) => replaceStateKeyInQueryString(_.defaultFilterStateKey, {
  query,
  ...getTimeRange(time, timeRange),
  refreshInterval: _.DEFAULT_REFRESH_INTERVAL
});
exports.replaceLogFilterInQueryString = replaceLogFilterInQueryString;
const getTimeRange = (time, timeRange) => {
  if (timeRange) {
    return {
      timeRange: {
        from: new Date(timeRange.startTime).toISOString(),
        to: new Date(timeRange.endTime).toISOString()
      }
    };
  } else if (time) {
    return {
      timeRange: {
        from: getTimeRangeStartFromTime(time),
        to: getTimeRangeEndFromTime(time)
      }
    };
  } else {
    return {};
  }
};
const defaultTimeRangeFromPositionOffset = {
  hours: 1
};
const getTimeRangeStartFromTime = time => (0, _moment.default)(time).subtract(defaultTimeRangeFromPositionOffset).toISOString();
exports.getTimeRangeStartFromTime = getTimeRangeStartFromTime;
const getTimeRangeEndFromTime = time => (0, _moment.default)(time).add(defaultTimeRangeFromPositionOffset).toISOString();
exports.getTimeRangeEndFromTime = getTimeRangeEndFromTime;