"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReducer = void 0;
var _redux = require("redux");
var _detail_panel = require("./detail_panel");
var _indices = require("./indices");
var _row_status = require("./row_status");
var _table_state = require("./table_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReducer = ({
  uiMetricService
}) => (0, _redux.combineReducers)({
  indices: _indices.indices,
  rowStatus: _row_status.rowStatus,
  tableState: _table_state.tableState,
  detailPanel: (0, _detail_panel.getDetailPanelReducer)(uiMetricService)
});
exports.getReducer = getReducer;