"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexList = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _detail_panel = require("./detail_panel");
var _index_table = require("./index_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexList = ({
  history
}) => {
  const {
    core: {
      executionContext
    }
  } = (0, _app_context.useAppContext)();
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'indexManagementIndicesTab'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `${_shared_imports.APP_WRAPPER_CLASS} im-snapshotTestSubject`,
    "data-test-subj": "indicesList"
  }, /*#__PURE__*/_react.default.createElement(_index_table.IndexTable, {
    history: history
  }), /*#__PURE__*/_react.default.createElement(_detail_panel.DetailPanel, null));
};
exports.IndexList = IndexList;