"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSettingsJson = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _documentation = require("../../../../../services/documentation");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../constants");
var _edit_settings = require("../../../../../lib/edit_settings");
var _ace = require("../../../../../lib/ace");
var _lodash = _interopRequireDefault(require("lodash"));
var _flatten_object = require("../../../../../lib/flatten_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EditSettingsJson extends _react.default.PureComponent {
  constructor() {
    super();
    (0, _defineProperty2.default)(this, "commitSettings", () => {
      const {
        updateIndexSettings,
        indexName
      } = this.props;
      const json = this.editor.getValue();
      const settings = JSON.parse(json);
      //don't set if the values have not changed
      Object.keys(this.originalSettings).forEach(key => {
        if (_lodash.default.isEqual(this.originalSettings[key], settings[key])) {
          delete settings[key];
        }
      });
      updateIndexSettings({
        indexName,
        settings
      });
    });
    this.state = {
      valid: true
    };
  }

  //API expects settings in flattened dotted form,
  //whereas they come back as nested objects from ES
  transformSettingsForApi(data, isOpen) {
    const {
      defaults,
      settings
    } = data;
    //settings user has actually set
    const flattenedSettings = (0, _flatten_object.flattenObject)(settings);
    //settings with their defaults
    const flattenedDefaults = (0, _flatten_object.flattenObject)(defaults);
    const filteredDefaults = _lodash.default.pick(flattenedDefaults, _edit_settings.settingsToDisplay);
    const newSettings = {
      ...filteredDefaults,
      ...flattenedSettings
    };
    //store these to be used as autocomplete values later
    this.settingsKeys = Object.keys(newSettings);
    _edit_settings.readOnlySettings.forEach(e => delete newSettings[e]);
    //can't change codec on open index
    if (isOpen) {
      delete newSettings['index.codec'];
    }
    return newSettings;
  }
  UNSAFE_componentWillMount() {
    const {
      indexName
    } = this.props;
    this.props.loadIndexData({
      dataType: _constants.TAB_SETTINGS,
      indexName
    });
  }
  componentDidUpdate() {
    const {
      data,
      indexStatus
    } = this.props;
    if (data && !this.editor) {
      const isOpen = indexStatus === 'open';
      const newSettings = this.transformSettingsForApi(data, isOpen);
      this.originalSettings = newSettings;
      const prettyJson = JSON.stringify(newSettings, null, 2);
      const settingsKeys = Object.keys(newSettings);
      const editor = this.editor = (0, _ace.createAceEditor)(this.aceDiv, prettyJson, false, settingsKeys);
      const session = editor.getSession();
      session.on('changeAnnotation', () => {
        const isEmptyString = session.getValue() === '';
        this.setState({
          valid: !isEmptyString && session.getAnnotations().length === 0
        });
      });
    }
  }
  componentWillUnmount() {
    this.editor && this.editor.destroy();
  }
  errorMessage() {
    const {
      error
    } = this.props;
    if (!error) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.idxMgmt.editSettingsJSON.saveJSONCalloutErrorTitle', {
        defaultMessage: 'There was an error while trying to save your settings'
      }),
      color: "danger",
      iconType: "warning",
      "data-test-subj": "updateIndexSettingsErrorCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, error)));
  }
  render() {
    const {
      data
    } = this.props;
    if (!data) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.editSettingsJSON.saveJSONDescription",
      defaultMessage: "Edit, then save your JSON"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      "data-test-subj": "updateEditIndexSettingsButton",
      onClick: this.commitSettings,
      disabled: !this.state.valid
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.editSettingsJSON.saveJSONButtonLabel",
      defaultMessage: "Save"
    })))), this.errorMessage(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _documentation.documentationService.getSettingsDocumentationLink(),
      target: "_blank",
      rel: "noopener"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.editSettingsJSON.settingsReferenceLinkText",
      defaultMessage: "Settings reference"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "indexJsonEditor",
      ref: aceDiv => {
        this.aceDiv = aceDiv;
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }
}
exports.EditSettingsJson = EditSettingsJson;