"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanel = void 0;
var _reactRedux = require("react-redux");
var _detail_panel = require("./detail_panel");
var _selectors = require("../../../../store/selectors");
var _actions = require("../../../../store/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  const indexName = (0, _selectors.getDetailPanelIndexName)(state);
  return {
    panelType: (0, _selectors.getDetailPanelType)(state),
    indexName,
    index: (0, _selectors.getIndexByIndexName)(state, indexName)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    clearCacheIndex: indexName => {
      dispatch((0, _actions.clearCacheIndices)({
        indexNames: [indexName]
      }));
    },
    closeIndex: indexName => {
      dispatch((0, _actions.closeIndices)({
        indexNames: [indexName]
      }));
    },
    flushIndex: indexName => {
      dispatch((0, _actions.flushIndices)({
        indexNames: [indexName]
      }));
    },
    openIndex: indexName => {
      dispatch((0, _actions.openIndices)({
        indexNames: [indexName]
      }));
    },
    refreshIndex: indexName => {
      dispatch((0, _actions.refreshIndices)({
        indexNames: [indexName]
      }));
    },
    forcemergeIndex: indexName => {
      dispatch((0, _actions.forcemergeIndices)({
        indexNames: [indexName]
      }));
    },
    deleteIndex: indexName => {
      dispatch((0, _actions.deleteIndices)({
        indexNames: [indexName]
      }));
    },
    closeDetailPanel: () => dispatch((0, _actions.closeDetailPanel)()),
    openDetailPanel: (indexName, panelType) => dispatch((0, _actions.openDetailPanel)(indexName, panelType))
  };
};
const DetailPanel = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_detail_panel.DetailPanel);
exports.DetailPanel = DetailPanel;