"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepAliases = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_json_step = require("./use_json_step");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepAliases = /*#__PURE__*/_react.default.memo(({
  defaultValue = {},
  onChange,
  esDocsBase
}) => {
  const {
    jsonContent,
    setJsonContent,
    error
  } = (0, _use_json_step.useJsonStep)({
    defaultValue,
    onChange
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "stepAliases"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "stepTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepAliases.stepTitle",
    defaultMessage: "Aliases (optional)"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepAliases.aliasesDescription",
    defaultMessage: "Set up aliases to associate with your indices."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: `${esDocsBase}/indices-aliases.html`,
    target: "_blank",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepAliases.docsButtonLabel",
    defaultMessage: "Index Aliases docs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.formWizard.stepAliases.fieldAliasesLabel",
      defaultMessage: "Aliases"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.formWizard.stepAliases.aliasesEditorHelpText",
      defaultMessage: "Use JSON format: {code}",
      values: {
        code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, JSON.stringify({
          my_alias: {}
        }))
      }
    }),
    isInvalid: Boolean(error),
    error: error,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    languageId: "json",
    value: jsonContent,
    "data-test-subj": "aliasesEditor",
    height: 500,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      automaticLayout: true
    },
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.formWizard.stepAliases.fieldAliasesAriaLabel', {
      defaultMessage: 'Aliases code editor'
    }),
    onChange: setJsonContent
  })));
});
exports.StepAliases = StepAliases;