"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PathParameter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _constants = require("../../../constants");
var _edit_field = require("../fields/edit_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const targetFieldTypeNotAllowed = _constants.PARAMETERS_DEFINITION.path.targetTypesNotAllowed;
const getSuggestedFields = (allFields, currentField) => Object.entries(allFields).filter(([id, field]) => {
  if (currentField && id === currentField.id) {
    return false;
  }

  // An alias cannot point certain field types ("object", "nested", "alias")
  if (targetFieldTypeNotAllowed.includes(field.source.type)) {
    return false;
  }
  return true;
}).map(([id, field]) => ({
  id,
  label: field.path.join(' > ')
})).sort((a, b) => a.label > b.label ? 1 : a.label < b.label ? -1 : 0);
const getDeserializer = allFields => value => {
  if (typeof value === 'string' && Boolean(value)) {
    return [{
      id: value,
      label: allFields[value].path.join(' > ')
    }];
  }
  return [];
};
const PathParameter = ({
  field,
  allFields
}) => {
  const suggestedFields = getSuggestedFields(allFields, field);
  const fieldConfig = (0, _react.useMemo)(() => ({
    ...(0, _lib.getFieldConfig)('path'),
    deserializer: getDeserializer(allFields)
  }), [allFields]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "path",
    config: fieldConfig
  }, pathField => {
    const error = pathField.getErrorsMessages();
    const isInvalid = error ? Boolean(error.length) : false;
    return /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
      title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.aliasType.aliasTargetFieldTitle', {
        defaultMessage: 'Alias target'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.aliasType.aliasTargetFieldDescription', {
        defaultMessage: 'Select the field you want your alias to point to. You will then be able to use the alias instead of the target field in search requests and select other APIs like field capabilities.'
      }),
      withToggle: false
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !Boolean(suggestedFields.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "warning",
      title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.aliasType.noFieldsAddedWarningMessage', {
        defaultMessage: 'You need to add at least one field before creating an alias.'
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: pathField.label,
      helpText: pathField.helpText,
      error: error,
      isInvalid: isInvalid,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.aliasType.pathPlaceholderLabel', {
        defaultMessage: 'Select a field'
      }),
      singleSelection: {
        asPlainText: true
      },
      options: suggestedFields,
      selectedOptions: pathField.value,
      onChange: value => pathField.setValue(value),
      isClearable: false,
      fullWidth: true
    }))));
  });
};
exports.PathParameter = PathParameter;