"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimulateTemplate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _template_serialization = require("../../../../../common/lib/template_serialization");
var _services = require("../../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  stripEmptyFields
} = _shared_imports.serializers;
const SimulateTemplate = /*#__PURE__*/_react.default.memo(({
  template,
  filters
}) => {
  const [templatePreview, setTemplatePreview] = (0, _react.useState)('{}');
  const updatePreview = (0, _react.useCallback)(async () => {
    var _filteredTemplate;
    if (!template || Object.keys(template).length === 0) {
      return;
    }
    const indexTemplate = (0, _template_serialization.serializeTemplate)(stripEmptyFields(template, {
      types: ['string']
    }));
    const {
      data,
      error
    } = await (0, _services.simulateIndexTemplate)(indexTemplate);
    let filteredTemplate = data;
    if (data) {
      // "Overlapping" info is only useful when simulating against an index
      // which we don't do here.
      delete data.overlapping;
      if (data.template && data.template.mappings === undefined) {
        // Adding some extra logic to return an empty object for "mappings" as ES does not
        // return one in that case (empty objects _are_ returned for "settings" and "aliases")
        // Issue: https://github.com/elastic/elasticsearch/issues/60968
        data.template.mappings = {};
      }
      if (filters) {
        filteredTemplate = Object.entries(filters).reduce((acc, [key, value]) => {
          if (!value) {
            delete acc[key];
          }
          return acc;
        }, {
          ...data.template
        });
      }
    }
    setTemplatePreview(JSON.stringify((_filteredTemplate = filteredTemplate) !== null && _filteredTemplate !== void 0 ? _filteredTemplate : error, null, 2));
  }, [template, filters]);
  (0, _react.useEffect)(() => {
    updatePreview();
  }, [updatePreview]);
  const isEmpty = templatePreview === '{}';
  const hasFilters = Boolean(filters);
  if (isEmpty && hasFilters) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.simulateTemplate.noFilterSelected",
        defaultMessage: "Select at least one option to preview."
      }),
      iconType: "pin",
      size: "s"
    });
  }
  return isEmpty ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    "data-test-subj": "simulateTemplatePreview"
  }, templatePreview);
});
exports.SimulateTemplate = SimulateTemplate;