"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useComponentTemplatesContext = exports.useApi = exports.ComponentTemplatesProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lib = require("./lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTemplatesContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const ComponentTemplatesProvider = ({
  children,
  value
}) => {
  const {
    overlays,
    httpClient,
    apiBasePath,
    trackMetric,
    docLinks,
    toasts,
    setBreadcrumbs,
    getUrlForApp,
    executionContext
  } = value;
  const useRequest = (0, _lib.getUseRequest)(httpClient);
  const sendRequest = (0, _lib.getSendRequest)(httpClient);
  const api = (0, _lib.getApi)(useRequest, sendRequest, apiBasePath, trackMetric);
  const documentation = (0, _lib.getDocumentation)(docLinks);
  const breadcrumbs = (0, _lib.getBreadcrumbs)(setBreadcrumbs);
  return /*#__PURE__*/_react.default.createElement(ComponentTemplatesContext.Provider, {
    value: {
      overlays,
      api,
      documentation,
      trackMetric,
      toasts,
      httpClient,
      apiBasePath,
      breadcrumbs,
      getUrlForApp,
      executionContext
    }
  }, children);
};
exports.ComponentTemplatesProvider = ComponentTemplatesProvider;
const useComponentTemplatesContext = () => {
  const ctx = (0, _react.useContext)(ComponentTemplatesContext);
  if (!ctx) {
    throw new Error('"useComponentTemplatesContext" can only be called inside of ComponentTemplatesProvider!');
  }
  return ctx;
};
exports.useComponentTemplatesContext = useComponentTemplatesContext;
const useApi = () => useComponentTemplatesContext().api;
exports.useApi = useApi;