"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepReview = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  stripEmptyFields
} = _shared_imports.serializers;
const getDescriptionText = data => {
  const hasEntries = data && Object.entries(data).length > 0;
  return hasEntries ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepReview.summaryTab.yesDescriptionText",
    defaultMessage: "Yes"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepReview.summaryTab.noDescriptionText",
    defaultMessage: "No"
  });
};
const StepReview = /*#__PURE__*/_react.default.memo(({
  dataStreams,
  componentTemplate
}) => {
  var _componentTemplate$_m;
  const {
    name
  } = componentTemplate;
  const serializedComponentTemplate = (0, _shared_imports.serializeComponentTemplate)(stripEmptyFields(componentTemplate, {
    types: ['string']
  }));
  const {
    template: serializedTemplate,
    _meta: serializedMeta,
    version: serializedVersion
  } = serializedComponentTemplate;
  const isFleetDatastreamsVisible = Boolean(dataStreams === null || dataStreams === void 0 ? void 0 : dataStreams.length) && ((_componentTemplate$_m = componentTemplate._meta) === null || _componentTemplate$_m === void 0 ? void 0 : _componentTemplate$_m.managed_by) === _constants.MANAGED_BY_FLEET;
  const SummaryTab = () => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "summaryTab"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, typeof serializedVersion !== 'undefined' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.versionLabel",
    defaultMessage: "Version"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, serializedVersion)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepReview.summaryTab.settingsLabel",
    defaultMessage: "Index settings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, getDescriptionText(serializedTemplate === null || serializedTemplate === void 0 ? void 0 : serializedTemplate.settings)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepReview.summaryTab.mappingLabel",
    defaultMessage: "Mappings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, getDescriptionText(serializedTemplate === null || serializedTemplate === void 0 ? void 0 : serializedTemplate.mappings)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepReview.summaryTab.aliasesLabel",
    defaultMessage: "Aliases"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, getDescriptionText(serializedTemplate === null || serializedTemplate === void 0 ? void 0 : serializedTemplate.aliases)))), isFleetDatastreamsVisible && dataStreams && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.datastreamsLabel",
    defaultMessage: "Mappings will immediately be applied to the following datastreams:"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, dataStreams.map(dataStream => /*#__PURE__*/_react.default.createElement("li", {
    key: dataStream
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataStream)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, serializedMeta && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.metaLabel",
    defaultMessage: "Metadata"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json"
  }, JSON.stringify(serializedMeta, null, 2)))))));
  const RequestTab = () => {
    const endpoint = `PUT _component_template/${name || '<componentTemplateName>'}`;
    const templateString = JSON.stringify(serializedComponentTemplate, null, 2);
    const request = `${endpoint}\n${templateString}`;

    // Beyond a certain point, highlighting the syntax will bog down performance to unacceptable
    // levels. This way we prevent that happening for very large requests.
    const language = request.length < 60000 ? 'json' : undefined;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "requestTab"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepReview.requestTab.descriptionText",
      defaultMessage: "This request will create the following component template."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: language,
      isCopyable: true
    }, request), isFleetDatastreamsVisible && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepReview.requestTab.datastreamNote",
      defaultMessage: "Datastreams using that template need to be updated with aditionnal requests."
    })))));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "stepReview"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepReview.stepTitle",
    defaultMessage: "Review details for '{templateName}'",
    values: {
      templateName: name
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "content",
    tabs: [{
      id: 'summary',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepReview.summaryTabTitle', {
        defaultMessage: 'Summary'
      }),
      content: /*#__PURE__*/_react.default.createElement(SummaryTab, null)
    }, {
      id: 'request',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepReview.requestTabTitle', {
        defaultMessage: 'Request'
      }),
      content: /*#__PURE__*/_react.default.createElement(RequestTab, null)
    }]
  }));
});
exports.StepReview = StepReview;