"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateEdit = void 0;
exports.useStepFromQueryString = useStepFromQueryString;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _component_templates_context = require("../../component_templates_context");
var _shared_imports = require("../../shared_imports");
var _component_template_form = require("../component_template_form");
var _redirect_path = require("../../../../hooks/redirect_path");
var _constants = require("../../constants");
var _mappings_datastreams_rollover_modal = require("./mappings_datastreams_rollover_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStepFromQueryString(history) {
  const activeStep = (0, _react.useMemo)(() => {
    const params = new URLSearchParams(history.location.search);
    if (params.has('step')) {
      return params.get('step');
    }
  }, [history.location.search]);
  const updateStep = (0, _react.useCallback)(stepId => {
    const params = new URLSearchParams(history.location.search);
    if (params.has('step')) {
      params.set('step', stepId);
      history.push({
        search: params.toString()
      });
    }
  }, [history]);
  return {
    activeStep,
    updateStep
  };
}
const ComponentTemplateEdit = ({
  match: {
    params: {
      name
    }
  },
  history
}) => {
  const {
    api,
    breadcrumbs,
    overlays
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const {
    activeStep: defaultActiveStep,
    updateStep
  } = useStepFromQueryString(history);
  const redirectTo = (0, _redirect_path.useRedirectPath)(history);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const decodedName = (0, _shared_imports.attemptToURIDecode)(name);
  const {
    error,
    data: componentTemplate,
    isLoading
  } = api.useLoadComponentTemplate(decodedName);
  const {
    data: dataStreamResponse
  } = api.useLoadComponentTemplatesDatastream(decodedName);
  const dataStreams = (0, _react.useMemo)(() => {
    var _dataStreamResponse$d;
    return (_dataStreamResponse$d = dataStreamResponse === null || dataStreamResponse === void 0 ? void 0 : dataStreamResponse.data_streams) !== null && _dataStreamResponse$d !== void 0 ? _dataStreamResponse$d : [];
  }, [dataStreamResponse]);
  (0, _react.useEffect)(() => {
    breadcrumbs.setEditBreadcrumbs();
  }, [breadcrumbs]);
  const onSave = async updatedComponentTemplate => {
    var _updatedComponentTemp;
    setIsSaving(true);
    setSaveError(null);
    const {
      error: saveErrorObject
    } = await api.updateComponentTemplate(updatedComponentTemplate);
    setIsSaving(false);
    if (saveErrorObject) {
      setSaveError(saveErrorObject);
      return;
    }
    if (((_updatedComponentTemp = updatedComponentTemplate._meta) === null || _updatedComponentTemp === void 0 ? void 0 : _updatedComponentTemp.managed_by) === _constants.MANAGED_BY_FLEET && dataStreams.length) {
      const dataStreamsToRollover = [];
      for (const dataStream of dataStreams) {
        try {
          const {
            error: applyMappingError
          } = await api.postDataStreamMappingsFromTemplate(dataStream);
          if (applyMappingError) {
            throw applyMappingError;
          }
        } catch (err) {
          dataStreamsToRollover.push(dataStream);
        }
      }
      if (dataStreamsToRollover.length) {
        const ref = overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_mappings_datastreams_rollover_modal.MappingsDatastreamRolloverModal, {
          componentTemplatename: updatedComponentTemplate.name,
          dataStreams: dataStreamsToRollover,
          api: api,
          onClose: () => {
            ref.close();
          }
        })));
        await ref.onClose;
      }
    }
    redirectTo({
      pathname: encodeURI(`/component_templates/${encodeURIComponent(updatedComponentTemplate.name)}`)
    });
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.loadingDescription",
      defaultMessage: "Loading component template\u2026"
    }));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateEdit.loadComponentTemplateError",
        defaultMessage: "Error loading component template"
      }),
      error: error,
      "data-test-subj": "loadComponentTemplateError"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.editPageTitle",
      defaultMessage: "Edit component template '{name}'",
      values: {
        name: decodedName
      }
    })),
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_component_template_form.ComponentTemplateForm, {
    defaultValue: componentTemplate,
    dataStreams: dataStreams,
    defaultActiveWizardSection: defaultActiveStep,
    onStepChange: updateStep,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError,
    isEditing: true
  }));
};
exports.ComponentTemplateEdit = ComponentTemplateEdit;