"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateButtonPopOver = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateButtonPopOver = ({
  anchorPosition = 'upCenter'
}) => {
  const [isPopoverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "createComponentTemplatePanel",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": "manageTemplateButton",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => setIsPopOverOpen(prev => !prev)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplatesFlyout.manageButtonLabel",
      defaultMessage: "Create"
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopOverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: anchorPosition,
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesFlyout.createContextMenuPanelTitle', {
        defaultMessage: 'New component template'
      }),
      items: [{
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesFlyout.createComponentTemplateFromScratchButtonLabel', {
          defaultMessage: 'From scratch'
        }),
        icon: 'plusInCircle',
        onClick: () => {
          // console.log('Create component template...');
        }
      }, {
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesFlyout.createComponentTemplateFromExistingButtonLabel', {
          defaultMessage: 'From existing index template'
        }),
        icon: 'symlink',
        onClick: () => {
          // console.log('Create component template from index template...');
        }
      }]
    }]
  }));
};
exports.CreateButtonPopOver = CreateButtonPopOver;