"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WarmPhase = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _form = require("../../../form");
var _shared_fields = require("../shared_fields");
var _phase = require("../phase");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  dataTierAllocation: {
    description: _i18n.i18n.translate('xpack.indexLifecycleMgmt.warmPhase.dataTier.description', {
      defaultMessage: 'Move data to nodes optimized for less-frequent, read-only access.'
    })
  }
};
const WarmPhase = () => {
  const {
    isUsingSearchableSnapshotInHotPhase,
    isUsingDownsampleInHotPhase,
    isUsingDownsampleInWarmPhase
  } = (0, _form.useConfiguration)();
  return /*#__PURE__*/_react.default.createElement(_phase.Phase, {
    phase: "warm"
  }, /*#__PURE__*/_react.default.createElement(_shared_fields.ReplicasField, {
    phase: "warm"
  }), !isUsingSearchableSnapshotInHotPhase && /*#__PURE__*/_react.default.createElement(_shared_fields.ShrinkField, {
    phase: "warm"
  }), !isUsingSearchableSnapshotInHotPhase && /*#__PURE__*/_react.default.createElement(_shared_fields.ForcemergeField, {
    phase: "warm"
  }), !isUsingSearchableSnapshotInHotPhase && /*#__PURE__*/_react.default.createElement(_shared_fields.DownsampleField, {
    phase: "warm"
  }), !isUsingSearchableSnapshotInHotPhase && !isUsingDownsampleInHotPhase && !isUsingDownsampleInWarmPhase && /*#__PURE__*/_react.default.createElement(_shared_fields.ReadonlyField, {
    phase: "warm"
  }), /*#__PURE__*/_react.default.createElement(_shared_fields.DataTierAllocationField, {
    description: i18nTexts.dataTierAllocation.description,
    phase: "warm"
  }), /*#__PURE__*/_react.default.createElement(_shared_fields.IndexPriorityField, {
    phase: "warm"
  }));
};
exports.WarmPhase = WarmPhase;