"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditWarning = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _edit_policy_context = require("../edit_policy_context");
var _navigation = require("../../../services/navigation");
var _shared_imports = require("../../../../shared_imports");
var _index_templates_flyout = require("../../../components/index_templates_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditWarning = () => {
  var _policy$_meta;
  const {
    isNewPolicy,
    indices,
    indexTemplates,
    policyName,
    policy
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const {
    services: {
      getUrlForApp
    }
  } = (0, _shared_imports.useKibana)();
  const [isIndexTemplatesFlyoutShown, setIsIndexTemplatesShown] = (0, _react.useState)(false);
  if (isNewPolicy) {
    return null;
  }
  const indicesLink = indices.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "linkedIndicesLink",
    external: true,
    href: (0, _navigation.getIndicesListPath)(policyName !== null && policyName !== void 0 ? policyName : '', getUrlForApp),
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.linkedIndices",
    defaultMessage: "{indicesCount, plural, one {# linked index} other {# linked indices}}",
    values: {
      indicesCount: indices.length
    }
  })) : null;
  const indexTemplatesLink = indexTemplates.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "linkedIndexTemplatesLink",
    onClick: () => setIsIndexTemplatesShown(!isIndexTemplatesFlyoutShown)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.linkedIndexTemplates",
    defaultMessage: "{indexTemplatesCount, plural, one {# linked index template} other {# linked index templates}}",
    values: {
      indexTemplatesCount: indexTemplates.length
    }
  })) : null;
  const dependenciesLinks = indicesLink ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesLink, indexTemplatesLink ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.andDependenciesLink",
    defaultMessage: " and {indexTemplatesLink}",
    values: {
      indexTemplatesLink
    }
  }) : null) : indexTemplatesLink;
  const isManagedPolicy = policy === null || policy === void 0 ? void 0 : (_policy$_meta = policy._meta) === null || _policy$_meta === void 0 ? void 0 : _policy$_meta.managed;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isIndexTemplatesFlyoutShown && /*#__PURE__*/_react.default.createElement(_index_templates_flyout.IndexTemplatesFlyout, {
    policyName: policyName !== null && policyName !== void 0 ? policyName : '',
    indexTemplates: indexTemplates,
    close: () => setIsIndexTemplatesShown(false)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "editWarning"
  }, isManagedPolicy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicyModal.proceedWithCautionCallOutTitle",
      defaultMessage: "Editing a managed policy can break Kibana"
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "editManagedPolicyCallOut"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicyModal.proceedWithCautionCallOutDescription",
    defaultMessage: "Managed policies are critical for internal operations."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.editingExistingPolicyMessage",
    defaultMessage: "You are editing an existing policy."
  })), dependenciesLinks ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.dependenciesMessage",
    defaultMessage: " Any changes you make will affect {dependenciesLinks} that {count, plural, one {is} other {are}} attached to this policy.",
    values: {
      dependenciesLinks,
      count: indices.length + indexTemplates.length
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.saveAsNewMessage",
    defaultMessage: " Alternatively, you can save these changes in a new policy."
  }))));
};
exports.EditWarning = EditWarning;