"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidedOnboardingPlugin = void 0;
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../common/constants");
var _components = require("./components");
var _api = require("./services/api.service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class GuidedOnboardingPlugin {
  constructor() {}
  setup(core) {
    return {};
  }
  start(core, {
    cloud
  }) {
    const {
      chrome,
      http,
      theme,
      application,
      notifications,
      uiSettings
    } = core;

    // Guided onboarding UI is only available on cloud and if the access to the Kibana feature is granted
    const isEnabled = !!(cloud !== null && cloud !== void 0 && cloud.isCloudEnabled && application.capabilities[_constants.PLUGIN_FEATURE].enabled);
    // Initialize services
    _api.apiService.setup(http, isEnabled);
    if (isEnabled) {
      chrome.navControls.registerExtension({
        order: 1000,
        mount: target => this.mount({
          targetDomElement: target,
          theme$: theme.theme$,
          api: _api.apiService,
          application,
          notifications,
          uiSettings
        })
      });
    }

    // Return methods that should be available to other plugins
    return {
      guidedOnboardingApi: _api.apiService
    };
  }
  stop() {}
  mount({
    targetDomElement,
    theme$,
    api,
    application,
    notifications,
    uiSettings
  }) {
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_components.GuidePanel, {
      api: api,
      application: application,
      notifications: notifications,
      uiSettings: uiSettings
    }))), targetDomElement);
    return () => _reactDom.default.unmountComponentAtNode(targetDomElement);
  }
}
exports.GuidedOnboardingPlugin = GuidedOnboardingPlugin;