"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSearchParams = void 0;
var _eui = require("@elastic/eui");
var _query_utils = require("./query_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const knownFilters = ['tag', 'type'];
const aliasMap = {
  tag: ['tags'],
  type: ['types']
};
const parseSearchParams = term => {
  let query;
  try {
    query = _eui.Query.parse(term);
  } catch (e) {
    // if the query fails to parse, we just perform the search against the raw search term.
    return {
      term,
      filters: {
        unknowns: {}
      }
    };
  }
  const searchTerm = (0, _query_utils.getSearchTerm)(query);
  const filterValues = (0, _query_utils.applyAliases)((0, _query_utils.getFieldValueMap)(query), aliasMap);
  const unknownFilters = [...filterValues.entries()].filter(([key]) => !knownFilters.includes(key)).reduce((unknowns, [key, value]) => {
    return {
      ...unknowns,
      [key]: value
    };
  }, {});
  const tags = filterValues.get('tag');
  const types = filterValues.get('type');
  return {
    term: searchTerm,
    filters: {
      tags: tags ? valuesToString(tags) : undefined,
      types: types ? valuesToString(types) : undefined,
      unknowns: unknownFilters
    }
  };
};
exports.parseSearchParams = parseSearchParams;
const valuesToString = raw => raw.map(value => String(value));