"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalSearchBarPlugin = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _search_bar = require("./components/search_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GlobalSearchBarPlugin {
  setup() {
    return {};
  }
  start(core, startDeps) {
    core.chrome.navControls.registerCenter(this.getNavControl({
      core,
      ...startDeps
    }));
    return {};
  }
  getNavControl(deps) {
    const {
      core,
      globalSearch,
      savedObjectsTagging,
      usageCollection
    } = deps;
    const {
      application,
      http,
      theme,
      uiSettings
    } = core;
    let trackUiMetric = () => {};
    if (usageCollection) {
      trackUiMetric = (...args) => {
        // track UI Counter metrics
        usageCollection.reportUiCounter('global_search_bar', ...args);

        // TODO track EBT metrics using core.analytics
      };
    }

    const navControl = {
      order: 1000,
      mount: container => {
        _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
          theme$: theme.theme$
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
          globalSearch: globalSearch,
          navigateToUrl: application.navigateToUrl,
          taggingApi: savedObjectsTagging,
          basePathUrl: http.basePath.prepend('/plugins/globalSearchBar/assets/'),
          darkMode: uiSettings.get('theme:darkMode'),
          chromeStyle$: core.chrome.getChromeStyle$(),
          trackUiMetric: trackUiMetric
        }))), container);
        return () => _reactDom.default.unmountComponentAtNode(container);
      }
    };
    return navControl;
  }
}
exports.GlobalSearchBarPlugin = GlobalSearchBarPlugin;